/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.discovery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.discovery.DruidService;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.server.coordination.ServerType;

public class DataNodeService
extends DruidService {
    public static final String DISCOVERY_SERVICE_KEY = "dataNodeService";
    public static final String SERVER_TYPE_PROP_KEY = "serverType";
    private final String tier;
    private final long maxSize;
    private final ServerType serverType;
    private final int priority;
    private final boolean isDiscoverable;

    @JsonCreator
    public static DataNodeService fromJson(@JsonProperty(value="tier") String tier, @JsonProperty(value="maxSize") long maxSize, @JsonProperty(value="type") @Deprecated @Nullable ServerType type, @JsonProperty(value="serverType") @Nullable ServerType serverType, @JsonProperty(value="priority") int priority) {
        if (type == null && serverType == null) {
            throw new IAE("ServerType is missing", new Object[0]);
        }
        ServerType theServerType = serverType == null ? type : serverType;
        return new DataNodeService(tier, maxSize, theServerType, priority);
    }

    public DataNodeService(String tier, long maxSize, ServerType serverType, int priority) {
        this(tier, maxSize, serverType, priority, true);
    }

    public DataNodeService(String tier, long maxSize, ServerType serverType, int priority, boolean isDiscoverable) {
        this.tier = tier;
        this.maxSize = maxSize;
        this.serverType = serverType;
        this.priority = priority;
        this.isDiscoverable = isDiscoverable;
    }

    @Override
    public String getName() {
        return DISCOVERY_SERVICE_KEY;
    }

    public String getTier() {
        return this.tier;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public ServerType getServerType() {
        return this.serverType;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    @JsonIgnore
    public boolean isDiscoverable() {
        return this.isDiscoverable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataNodeService that = (DataNodeService)o;
        return this.maxSize == that.maxSize && this.priority == that.priority && Objects.equals(this.tier, that.tier) && this.serverType == that.serverType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tier, this.maxSize, this.serverType, this.priority});
    }

    public String toString() {
        return "DataNodeService{tier='" + this.tier + "', maxSize=" + this.maxSize + ", serverType=" + this.serverType + ", priority=" + this.priority + "}";
    }
}

