/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic.authentication.db.updater;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.druid.common.config.ConfigManager;
import org.apache.druid.concurrent.LifecycleLock;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.metadata.MetadataCASUpdate;
import org.apache.druid.metadata.MetadataStorageConnector;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.security.basic.BasicAuthCommonCacheConfig;
import org.apache.druid.security.basic.BasicAuthDBConfig;
import org.apache.druid.security.basic.BasicAuthUtils;
import org.apache.druid.security.basic.BasicSecurityDBResourceException;
import org.apache.druid.security.basic.authentication.BasicHTTPAuthenticator;
import org.apache.druid.security.basic.authentication.db.cache.BasicAuthenticatorCacheNotifier;
import org.apache.druid.security.basic.authentication.db.updater.BasicAuthenticatorMetadataStorageUpdater;
import org.apache.druid.security.basic.authentication.entity.BasicAuthenticatorCredentialUpdate;
import org.apache.druid.security.basic.authentication.entity.BasicAuthenticatorCredentials;
import org.apache.druid.security.basic.authentication.entity.BasicAuthenticatorUser;
import org.apache.druid.security.basic.authentication.entity.BasicAuthenticatorUserMapBundle;
import org.apache.druid.server.security.Authenticator;
import org.apache.druid.server.security.AuthenticatorMapper;
import org.joda.time.Duration;

@ManageLifecycle
public class CoordinatorBasicAuthenticatorMetadataStorageUpdater
implements BasicAuthenticatorMetadataStorageUpdater {
    private static final EmittingLogger LOG = new EmittingLogger(CoordinatorBasicAuthenticatorMetadataStorageUpdater.class);
    private static final String USERS = "users";
    private static final long UPDATE_RETRY_DELAY = 1000L;
    private final AuthenticatorMapper authenticatorMapper;
    private final MetadataStorageConnector connector;
    private final MetadataStorageTablesConfig connectorConfig;
    private final BasicAuthCommonCacheConfig commonCacheConfig;
    private final ObjectMapper objectMapper;
    private final BasicAuthenticatorCacheNotifier cacheNotifier;
    private static final int NUM_RETRIES = 5;
    private final Map<String, BasicAuthenticatorUserMapBundle> cachedUserMaps;
    private final Set<String> authenticatorPrefixes;
    private final LifecycleLock lifecycleLock = new LifecycleLock();
    private final ScheduledExecutorService exec = Execs.scheduledSingleThreaded((String)"CoordinatorBasicAuthenticatorMetadataStorageUpdater-Exec--%d");
    private volatile boolean stopped = false;

    @Inject
    public CoordinatorBasicAuthenticatorMetadataStorageUpdater(AuthenticatorMapper authenticatorMapper, MetadataStorageConnector connector, MetadataStorageTablesConfig connectorConfig, BasicAuthCommonCacheConfig commonCacheConfig, @Smile ObjectMapper objectMapper, BasicAuthenticatorCacheNotifier cacheNotifier, ConfigManager configManager) {
        this.authenticatorMapper = authenticatorMapper;
        this.connector = connector;
        this.connectorConfig = connectorConfig;
        this.commonCacheConfig = commonCacheConfig;
        this.objectMapper = objectMapper;
        this.cacheNotifier = cacheNotifier;
        this.cachedUserMaps = new ConcurrentHashMap<String, BasicAuthenticatorUserMapBundle>();
        this.authenticatorPrefixes = new HashSet<String>();
    }

    @LifecycleStart
    public void start() {
        if (!this.lifecycleLock.canStart()) {
            throw new ISE("can't start.", new Object[0]);
        }
        if (this.authenticatorMapper == null || this.authenticatorMapper.getAuthenticatorMap() == null) {
            return;
        }
        try {
            LOG.info("Starting CoordinatorBasicAuthenticatorMetadataStorageUpdater.", new Object[0]);
            BasicAuthUtils.maybeInitialize(() -> {
                for (Map.Entry entry : this.authenticatorMapper.getAuthenticatorMap().entrySet()) {
                    Authenticator authenticator = (Authenticator)entry.getValue();
                    if (!(authenticator instanceof BasicHTTPAuthenticator)) continue;
                    String authenticatorName = (String)entry.getKey();
                    this.authenticatorPrefixes.add(authenticatorName);
                    BasicHTTPAuthenticator basicHTTPAuthenticator = (BasicHTTPAuthenticator)authenticator;
                    BasicAuthDBConfig dbConfig = basicHTTPAuthenticator.getDbConfig();
                    byte[] userMapBytes = this.getCurrentUserMapBytes(authenticatorName);
                    Map<String, BasicAuthenticatorUser> userMap = BasicAuthUtils.deserializeAuthenticatorUserMap(this.objectMapper, userMapBytes);
                    this.cachedUserMaps.put(authenticatorName, new BasicAuthenticatorUserMapBundle(userMap, userMapBytes));
                    if (dbConfig.getInitialAdminPassword() != null && !userMap.containsKey("admin")) {
                        this.createUserInternal(authenticatorName, "admin");
                        this.setUserCredentialsInternal(authenticatorName, "admin", new BasicAuthenticatorCredentialUpdate(dbConfig.getInitialAdminPassword().getPassword(), 10000));
                    }
                    if (dbConfig.getInitialInternalClientPassword() == null || userMap.containsKey("druid_system")) continue;
                    this.createUserInternal(authenticatorName, "druid_system");
                    this.setUserCredentialsInternal(authenticatorName, "druid_system", new BasicAuthenticatorCredentialUpdate(dbConfig.getInitialInternalClientPassword().getPassword(), 10000));
                }
                return true;
            });
            ScheduledExecutors.scheduleWithFixedDelay((ScheduledExecutorService)this.exec, (Duration)new Duration(this.commonCacheConfig.getPollingPeriod()), (Duration)new Duration(this.commonCacheConfig.getPollingPeriod()), (Callable)new Callable<ScheduledExecutors.Signal>(){

                @Override
                public ScheduledExecutors.Signal call() {
                    if (CoordinatorBasicAuthenticatorMetadataStorageUpdater.this.stopped) {
                        return ScheduledExecutors.Signal.STOP;
                    }
                    try {
                        LOG.debug("Scheduled db userMap poll is running", new Object[0]);
                        for (String authenticatorPrefix : CoordinatorBasicAuthenticatorMetadataStorageUpdater.this.authenticatorPrefixes) {
                            byte[] userMapBytes = CoordinatorBasicAuthenticatorMetadataStorageUpdater.this.getCurrentUserMapBytes(authenticatorPrefix);
                            Map<String, BasicAuthenticatorUser> userMap = BasicAuthUtils.deserializeAuthenticatorUserMap(CoordinatorBasicAuthenticatorMetadataStorageUpdater.this.objectMapper, userMapBytes);
                            if (userMapBytes == null) continue;
                            CoordinatorBasicAuthenticatorMetadataStorageUpdater.this.cachedUserMaps.put(authenticatorPrefix, new BasicAuthenticatorUserMapBundle(userMap, userMapBytes));
                        }
                        LOG.debug("Scheduled db userMap poll is done", new Object[0]);
                    }
                    catch (Throwable t) {
                        LOG.makeAlert(t, "Error occurred while polling for cachedUserMaps.", new Object[0]).emit();
                    }
                    return ScheduledExecutors.Signal.REPEAT;
                }
            });
            this.lifecycleLock.started();
        }
        finally {
            this.lifecycleLock.exitStart();
        }
    }

    @LifecycleStop
    public void stop() {
        if (!this.lifecycleLock.canStop()) {
            throw new ISE("can't stop.", new Object[0]);
        }
        LOG.info("CoordinatorBasicAuthenticatorMetadataStorageUpdater is stopping.", new Object[0]);
        this.stopped = true;
        LOG.info("CoordinatorBasicAuthenticatorMetadataStorageUpdater is stopped.", new Object[0]);
    }

    @Override
    public void createUser(String prefix, String userName) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        this.createUserInternal(prefix, userName);
    }

    @Override
    public void deleteUser(String prefix, String userName) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        this.deleteUserInternal(prefix, userName);
    }

    @Override
    public void setUserCredentials(String prefix, String userName, BasicAuthenticatorCredentialUpdate update) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        this.setUserCredentialsInternal(prefix, userName, update);
    }

    @Override
    public Map<String, BasicAuthenticatorUser> getCachedUserMap(String prefix) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        BasicAuthenticatorUserMapBundle bundle = this.cachedUserMaps.get(prefix);
        if (bundle == null) {
            return null;
        }
        return bundle.getUserMap();
    }

    @Override
    public byte[] getCachedSerializedUserMap(String prefix) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        BasicAuthenticatorUserMapBundle bundle = this.cachedUserMaps.get(prefix);
        if (bundle == null) {
            return null;
        }
        return bundle.getSerializedUserMap();
    }

    @Override
    public byte[] getCurrentUserMapBytes(String prefix) {
        return this.connector.lookup(this.connectorConfig.getConfigTable(), "name", "payload", CoordinatorBasicAuthenticatorMetadataStorageUpdater.getPrefixedKeyColumn(prefix, USERS));
    }

    @Override
    public void refreshAllNotification() {
        this.cachedUserMaps.forEach((authenticatorName, userMapBundle) -> this.cacheNotifier.addUserUpdate((String)authenticatorName, userMapBundle.getSerializedUserMap()));
    }

    private static String getPrefixedKeyColumn(String keyPrefix, String keyName) {
        return StringUtils.format((String)"basic_authentication_%s_%s", (Object[])new Object[]{keyPrefix, keyName});
    }

    private void createUserInternal(String prefix, String userName) {
        for (int attempts = 0; attempts < 5; ++attempts) {
            if (this.createUserOnce(prefix, userName)) {
                return;
            }
            this.updateRetryDelay();
        }
        throw new ISE("Could not create user[%s] due to concurrent update contention.", new Object[]{userName});
    }

    private void deleteUserInternal(String prefix, String userName) {
        for (int attempts = 0; attempts < 5; ++attempts) {
            if (this.deleteUserOnce(prefix, userName)) {
                return;
            }
            this.updateRetryDelay();
        }
        throw new ISE("Could not delete user[%s] due to concurrent update contention.", new Object[]{userName});
    }

    private void updateRetryDelay() {
        try {
            Thread.sleep(ThreadLocalRandom.current().nextLong(1000L));
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    private void setUserCredentialsInternal(String prefix, String userName, BasicAuthenticatorCredentialUpdate update) {
        BasicAuthenticatorCredentials credentials;
        if (update.getIterations() == -1) {
            BasicHTTPAuthenticator authenticator = (BasicHTTPAuthenticator)this.authenticatorMapper.getAuthenticatorMap().get(prefix);
            credentials = new BasicAuthenticatorCredentials(new BasicAuthenticatorCredentialUpdate(update.getPassword(), authenticator.getDbConfig().getCredentialIterations()));
        } else {
            credentials = new BasicAuthenticatorCredentials(update);
        }
        for (int attempts = 0; attempts < 5; ++attempts) {
            if (this.setUserCredentialOnce(prefix, userName, credentials)) {
                return;
            }
            try {
                Thread.sleep(ThreadLocalRandom.current().nextLong(1000L));
                continue;
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }
        throw new ISE("Could not set credentials for user[%s] due to concurrent update contention.", new Object[]{userName});
    }

    private boolean createUserOnce(String prefix, String userName) {
        byte[] oldValue = this.getCurrentUserMapBytes(prefix);
        Map<String, BasicAuthenticatorUser> userMap = BasicAuthUtils.deserializeAuthenticatorUserMap(this.objectMapper, oldValue);
        if (userMap.get(userName) != null) {
            throw new BasicSecurityDBResourceException("User [%s] already exists.", userName);
        }
        userMap.put(userName, new BasicAuthenticatorUser(userName, null));
        byte[] newValue = BasicAuthUtils.serializeAuthenticatorUserMap(this.objectMapper, userMap);
        return this.tryUpdateUserMap(prefix, userMap, oldValue, newValue);
    }

    private boolean deleteUserOnce(String prefix, String userName) {
        byte[] oldValue = this.getCurrentUserMapBytes(prefix);
        Map<String, BasicAuthenticatorUser> userMap = BasicAuthUtils.deserializeAuthenticatorUserMap(this.objectMapper, oldValue);
        if (userMap.get(userName) == null) {
            throw new BasicSecurityDBResourceException("User [%s] does not exist.", userName);
        }
        userMap.remove(userName);
        byte[] newValue = BasicAuthUtils.serializeAuthenticatorUserMap(this.objectMapper, userMap);
        return this.tryUpdateUserMap(prefix, userMap, oldValue, newValue);
    }

    private boolean setUserCredentialOnce(String prefix, String userName, BasicAuthenticatorCredentials credentials) {
        byte[] oldValue = this.getCurrentUserMapBytes(prefix);
        Map<String, BasicAuthenticatorUser> userMap = BasicAuthUtils.deserializeAuthenticatorUserMap(this.objectMapper, oldValue);
        if (userMap.get(userName) == null) {
            throw new BasicSecurityDBResourceException("User [%s] does not exist.", userName);
        }
        userMap.put(userName, new BasicAuthenticatorUser(userName, credentials));
        byte[] newValue = BasicAuthUtils.serializeAuthenticatorUserMap(this.objectMapper, userMap);
        return this.tryUpdateUserMap(prefix, userMap, oldValue, newValue);
    }

    private boolean tryUpdateUserMap(String prefix, Map<String, BasicAuthenticatorUser> userMap, byte[] oldValue, byte[] newValue) {
        try {
            MetadataCASUpdate update = new MetadataCASUpdate(this.connectorConfig.getConfigTable(), "name", "payload", CoordinatorBasicAuthenticatorMetadataStorageUpdater.getPrefixedKeyColumn(prefix, USERS), oldValue, newValue);
            boolean succeeded = this.connector.compareAndSwap(Collections.singletonList(update));
            if (succeeded) {
                this.cachedUserMaps.put(prefix, new BasicAuthenticatorUserMapBundle(userMap, newValue));
                this.cacheNotifier.addUserUpdate(prefix, newValue);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

