/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream.common;

import java.util.Objects;

public abstract class OrderedSequenceNumber<SequenceOffsetType>
implements Comparable<OrderedSequenceNumber<SequenceOffsetType>> {
    private final SequenceOffsetType sequenceNumber;
    private final boolean isExclusive;

    protected OrderedSequenceNumber(SequenceOffsetType sequenceNumber, boolean isExclusive) {
        this.sequenceNumber = sequenceNumber;
        this.isExclusive = isExclusive;
    }

    public SequenceOffsetType get() {
        return this.sequenceNumber;
    }

    public boolean isExclusive() {
        return this.isExclusive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderedSequenceNumber that = (OrderedSequenceNumber)o;
        return this.isExclusive == that.isExclusive && Objects.equals(this.sequenceNumber, that.sequenceNumber);
    }

    public int hashCode() {
        return Objects.hash(this.sequenceNumber, this.isExclusive);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{sequenceNumber=" + this.sequenceNumber + ", isExclusive=" + this.isExclusive + "}";
    }

    public boolean isAvailableWithEarliest(OrderedSequenceNumber<SequenceOffsetType> earliest) {
        return earliest.compareTo(this) <= 0;
    }

    public boolean isMoreToReadBeforeReadingRecord(OrderedSequenceNumber<SequenceOffsetType> end, boolean isEndOffsetExclusive) {
        int compareToEnd = this.compareTo(end);
        return isEndOffsetExclusive ? compareToEnd < 0 : compareToEnd <= 0;
    }
}

