/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.scheduledbatch;

import com.cronutils.model.time.ExecutionTime;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.joda.time.DateTime;
import org.joda.time.Duration;

public class CronSchedulerUtils {
    @Nullable
    static DateTime getNextTaskStartTimeAfter(ExecutionTime executionTime, DateTime referenceTime) {
        Optional zonedDateTime = executionTime.nextExecution(CronSchedulerUtils.convertToZonedDateTime(referenceTime));
        if (zonedDateTime.isPresent()) {
            ZonedDateTime zdt = (ZonedDateTime)zonedDateTime.get();
            Instant instant = zdt.toInstant();
            return new DateTime(instant.toEpochMilli(), DateTimes.inferTzFromString((String)zdt.getZone().getId()));
        }
        return null;
    }

    @Nullable
    static Duration getDurationUntilNextTaskStartTimeAfter(ExecutionTime executionTime, DateTime referenceTime) {
        Optional duration = executionTime.timeToNextExecution(CronSchedulerUtils.convertToZonedDateTime(referenceTime));
        return duration.map(value -> Duration.millis((long)value.toMillis())).orElse(null);
    }

    private static ZonedDateTime convertToZonedDateTime(DateTime jodaDateTime) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(jodaDateTime.getMillis()), ZoneId.of(jodaDateTime.getZone().getID()));
    }
}

