/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.Objects;
import org.apache.druid.indexing.common.task.batch.parallel.PartitionLocation;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.timeline.partition.BuildingShardSpec;
import org.joda.time.Interval;

public class GenericPartitionLocation
implements PartitionLocation {
    private final String host;
    private final int port;
    private final boolean useHttps;
    private final String subTaskId;
    private final Interval interval;
    private final BuildingShardSpec shardSpec;

    @JsonCreator
    public GenericPartitionLocation(@JsonProperty(value="host") String host, @JsonProperty(value="port") int port, @JsonProperty(value="useHttps") boolean useHttps, @JsonProperty(value="subTaskId") String subTaskId, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="shardSpec") BuildingShardSpec shardSpec) {
        this.host = host;
        this.port = port;
        this.useHttps = useHttps;
        this.subTaskId = subTaskId;
        this.interval = interval;
        this.shardSpec = shardSpec;
    }

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public boolean isUseHttps() {
        return this.useHttps;
    }

    @Override
    @JsonProperty
    public String getSubTaskId() {
        return this.subTaskId;
    }

    @Override
    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    @JsonIgnore
    public int getBucketId() {
        return this.shardSpec.getBucketId();
    }

    @Override
    @JsonProperty
    public BuildingShardSpec getShardSpec() {
        return this.shardSpec;
    }

    final URI toIntermediaryDataServerURI(String supervisorTaskId) {
        return URI.create(StringUtils.format((String)"%s://%s:%d/druid/worker/v1/shuffle/task/%s/%s/partition?startTime=%s&endTime=%s&bucketId=%d", (Object[])new Object[]{this.useHttps ? "https" : "http", this.host, this.port, StringUtils.urlEncode((String)supervisorTaskId), StringUtils.urlEncode((String)this.subTaskId), this.interval.getStart(), this.interval.getEnd(), this.getBucketId()}));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericPartitionLocation that = (GenericPartitionLocation)o;
        return this.port == that.port && this.useHttps == that.useHttps && this.host.equals(that.host) && this.subTaskId.equals(that.subTaskId) && this.interval.equals((Object)that.interval) && this.shardSpec.equals(that.shardSpec);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.useHttps, this.subTaskId, this.interval, this.shardSpec);
    }

    public String toString() {
        return "GenericPartitionLocation{host='" + this.host + "', port=" + this.port + ", useHttps=" + this.useHttps + ", subTaskId='" + this.subTaskId + "', interval=" + this.interval + ", shardSpec=" + this.shardSpec + "}";
    }
}

