/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.RowIngestionMeters;

public class FilteringCloseableInputRowIterator
implements CloseableIterator<InputRow> {
    private final CloseableIterator<InputRow> delegate;
    private final Predicate<InputRow> filter;
    private final RowIngestionMeters rowIngestionMeters;
    private final ParseExceptionHandler parseExceptionHandler;
    private InputRow next;

    public FilteringCloseableInputRowIterator(CloseableIterator<InputRow> delegate, Predicate<InputRow> filter, RowIngestionMeters rowIngestionMeters, ParseExceptionHandler parseExceptionHandler) {
        this.delegate = delegate;
        this.filter = filter;
        this.rowIngestionMeters = rowIngestionMeters;
        this.parseExceptionHandler = parseExceptionHandler;
    }

    public boolean hasNext() {
        while (true) {
            try {
                while (this.next == null && this.delegate.hasNext()) {
                    InputRow row = (InputRow)this.delegate.next();
                    if (this.filter.test(row)) {
                        this.next = row;
                        continue;
                    }
                    this.rowIngestionMeters.incrementThrownAway();
                }
            }
            catch (ParseException e) {
                this.parseExceptionHandler.handle(e);
                continue;
            }
            break;
        }
        return this.next != null;
    }

    public InputRow next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        InputRow row = this.next;
        this.next = null;
        return row;
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

