/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.services.rds.model.TenantDatabase;
import com.amazonaws.services.rds.model.transform.TagStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.TenantDatabasePendingModifiedValuesStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class TenantDatabaseStaxUnmarshaller
implements Unmarshaller<TenantDatabase, StaxUnmarshallerContext> {
    private static TenantDatabaseStaxUnmarshaller instance;

    public TenantDatabase unmarshall(StaxUnmarshallerContext context) throws Exception {
        TenantDatabase tenantDatabase = new TenantDatabase();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return tenantDatabase;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("TenantDatabaseCreateTime", targetDepth)) {
                    tenantDatabase.setTenantDatabaseCreateTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBInstanceIdentifier", targetDepth)) {
                    tenantDatabase.setDBInstanceIdentifier(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TenantDBName", targetDepth)) {
                    tenantDatabase.setTenantDBName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    tenantDatabase.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MasterUsername", targetDepth)) {
                    tenantDatabase.setMasterUsername(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DbiResourceId", targetDepth)) {
                    tenantDatabase.setDbiResourceId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TenantDatabaseResourceId", targetDepth)) {
                    tenantDatabase.setTenantDatabaseResourceId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TenantDatabaseARN", targetDepth)) {
                    tenantDatabase.setTenantDatabaseARN(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CharacterSetName", targetDepth)) {
                    tenantDatabase.setCharacterSetName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NcharCharacterSetName", targetDepth)) {
                    tenantDatabase.setNcharCharacterSetName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DeletionProtection", targetDepth)) {
                    tenantDatabase.setDeletionProtection(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PendingModifiedValues", targetDepth)) {
                    tenantDatabase.setPendingModifiedValues(TenantDatabasePendingModifiedValuesStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TagList", targetDepth)) {
                    tenantDatabase.withTagList(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("TagList/Tag", targetDepth)) continue;
                tenantDatabase.withTagList(TagStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return tenantDatabase;
    }

    public static TenantDatabaseStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TenantDatabaseStaxUnmarshaller();
        }
        return instance;
    }
}

