/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.MetricQuery;
import com.amazonaws.services.rds.model.MetricReference;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class Metric
implements Serializable,
Cloneable {
    private String name;
    private SdkInternalList<MetricReference> references;
    private String statisticsDetails;
    private MetricQuery metricQuery;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Metric withName(String name) {
        this.setName(name);
        return this;
    }

    public List<MetricReference> getReferences() {
        if (this.references == null) {
            this.references = new SdkInternalList();
        }
        return this.references;
    }

    public void setReferences(Collection<MetricReference> references) {
        if (references == null) {
            this.references = null;
            return;
        }
        this.references = new SdkInternalList(references);
    }

    public Metric withReferences(MetricReference ... references) {
        if (this.references == null) {
            this.setReferences((Collection<MetricReference>)new SdkInternalList(references.length));
        }
        for (MetricReference ele : references) {
            this.references.add((Object)ele);
        }
        return this;
    }

    public Metric withReferences(Collection<MetricReference> references) {
        this.setReferences(references);
        return this;
    }

    public void setStatisticsDetails(String statisticsDetails) {
        this.statisticsDetails = statisticsDetails;
    }

    public String getStatisticsDetails() {
        return this.statisticsDetails;
    }

    public Metric withStatisticsDetails(String statisticsDetails) {
        this.setStatisticsDetails(statisticsDetails);
        return this;
    }

    public void setMetricQuery(MetricQuery metricQuery) {
        this.metricQuery = metricQuery;
    }

    public MetricQuery getMetricQuery() {
        return this.metricQuery;
    }

    public Metric withMetricQuery(MetricQuery metricQuery) {
        this.setMetricQuery(metricQuery);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getReferences() != null) {
            sb.append("References: ").append(this.getReferences()).append(",");
        }
        if (this.getStatisticsDetails() != null) {
            sb.append("StatisticsDetails: ").append(this.getStatisticsDetails()).append(",");
        }
        if (this.getMetricQuery() != null) {
            sb.append("MetricQuery: ").append(this.getMetricQuery());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Metric)) {
            return false;
        }
        Metric other = (Metric)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getReferences() == null ^ this.getReferences() == null) {
            return false;
        }
        if (other.getReferences() != null && !other.getReferences().equals(this.getReferences())) {
            return false;
        }
        if (other.getStatisticsDetails() == null ^ this.getStatisticsDetails() == null) {
            return false;
        }
        if (other.getStatisticsDetails() != null && !other.getStatisticsDetails().equals(this.getStatisticsDetails())) {
            return false;
        }
        if (other.getMetricQuery() == null ^ this.getMetricQuery() == null) {
            return false;
        }
        return other.getMetricQuery() == null || other.getMetricQuery().equals(this.getMetricQuery());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getReferences() == null ? 0 : this.getReferences().hashCode());
        hashCode = 31 * hashCode + (this.getStatisticsDetails() == null ? 0 : this.getStatisticsDetails().hashCode());
        hashCode = 31 * hashCode + (this.getMetricQuery() == null ? 0 : this.getMetricQuery().hashCode());
        return hashCode;
    }

    public Metric clone() {
        try {
            return (Metric)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

