/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.writeout;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.function.Supplier;
import org.apache.commons.io.input.NullInputStream;
import org.apache.druid.error.DruidException;
import org.apache.druid.io.ByteBufferInputStream;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.writeout.WriteOutBytes;

public class LazilyAllocatingHeapWriteOutBytes
extends WriteOutBytes {
    private final Supplier<WriteOutBytes> delegateSupplier;
    private ByteBuffer tmpBuffer = null;
    private WriteOutBytes delegate = null;
    private boolean open = true;

    public LazilyAllocatingHeapWriteOutBytes(Supplier<WriteOutBytes> delegateSupplier, Closer closer) {
        this.delegateSupplier = delegateSupplier;
        closer.register(() -> {
            this.open = false;
            this.tmpBuffer = null;
            this.delegate = null;
        });
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.checkOpen();
        boolean useBuffer = this.ensureBytes(4);
        if (useBuffer) {
            this.tmpBuffer.putInt(v);
            return;
        }
        this.delegate.writeInt(v);
    }

    @Override
    public long size() {
        if (this.delegate == null) {
            return this.tmpBuffer == null ? 0L : (long)this.tmpBuffer.position();
        }
        return this.delegate.size();
    }

    @Override
    public void writeTo(WritableByteChannel channel) throws IOException {
        this.checkOpen();
        if (this.delegate == null) {
            if (this.tmpBuffer == null) {
                return;
            }
            ByteBuffer tmpBufCopy = this.tmpBuffer.asReadOnlyBuffer();
            tmpBufCopy.flip();
            channel.write(tmpBufCopy);
        } else {
            this.delegate.writeTo(channel);
        }
    }

    @Override
    public InputStream asInputStream() throws IOException {
        this.checkOpen();
        if (this.delegate == null) {
            if (this.tmpBuffer == null) {
                return new NullInputStream();
            }
            ByteBuffer tmpBufCopy = this.tmpBuffer.asReadOnlyBuffer();
            tmpBufCopy.flip();
            return new ByteBufferInputStream(tmpBufCopy);
        }
        return this.delegate.asInputStream();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void readFully(long pos, ByteBuffer buffer) throws IOException {
        this.checkOpen();
        if (this.delegate == null) {
            if (this.tmpBuffer == null) {
                return;
            }
            if (pos > (long)this.tmpBuffer.position()) throw new BufferOverflowException();
            ByteBuffer tmpBufCopy = this.tmpBuffer.asReadOnlyBuffer();
            tmpBufCopy.flip().position((int)pos);
            if (tmpBufCopy.remaining() < buffer.remaining()) {
                throw new BufferUnderflowException();
            }
            tmpBufCopy.limit(tmpBufCopy.position() + buffer.remaining());
            buffer.put(tmpBufCopy);
            return;
        } else {
            this.delegate.readFully(pos, buffer);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkOpen();
        boolean useBuffer = this.ensureBytes(1);
        if (useBuffer) {
            this.tmpBuffer.put((byte)b);
            return;
        }
        this.delegate.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.write(ByteBuffer.wrap(b, off, len));
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.checkOpen();
        int numToWrite = src.remaining();
        boolean useBuffer = this.ensureBytes(numToWrite);
        if (useBuffer) {
            this.tmpBuffer.put(src);
            return numToWrite;
        }
        return this.delegate.write(src);
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    private void checkOpen() {
        if (!this.isOpen()) {
            throw DruidException.defensive("WriteOutBytes is already closed.", new Object[0]);
        }
    }

    private boolean ensureBytes(int numBytes) throws IOException {
        ByteBuffer newBuf;
        if (this.tmpBuffer == null) {
            if (this.delegate == null) {
                if (numBytes < 128) {
                    this.tmpBuffer = ByteBuffer.allocate(128);
                } else if (numBytes < 4096) {
                    this.tmpBuffer = ByteBuffer.allocate(4096);
                } else {
                    this.delegate = this.delegateSupplier.get();
                    return false;
                }
                return true;
            }
            return false;
        }
        if (numBytes < this.tmpBuffer.remaining()) {
            return true;
        }
        switch (this.tmpBuffer.capacity()) {
            case 128: {
                if (numBytes < 4096 - this.tmpBuffer.position()) {
                    newBuf = ByteBuffer.allocate(4096);
                    break;
                }
            }
            case 4096: {
                if (numBytes < 16384 - this.tmpBuffer.position()) {
                    newBuf = ByteBuffer.allocate(16384);
                    break;
                }
            }
            default: {
                newBuf = null;
            }
        }
        if (newBuf == null) {
            this.delegate = this.delegateSupplier.get();
            this.tmpBuffer.flip();
            this.delegate.write(this.tmpBuffer);
            this.tmpBuffer = null;
            return false;
        }
        this.tmpBuffer.flip();
        newBuf.put(this.tmpBuffer);
        this.tmpBuffer = newBuf;
        return true;
    }

    @VisibleForTesting
    ByteBuffer getTmpBuffer() {
        return this.tmpBuffer;
    }

    @VisibleForTesting
    WriteOutBytes getDelegate() {
        return this.delegate;
    }
}

