/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.segment.filter.FalseFilter;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.join.Equality;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.utils.CollectionUtils;

public class JoinableFactoryWrapper {
    private final JoinableFactory joinableFactory;

    @Inject
    public JoinableFactoryWrapper(JoinableFactory joinableFactory) {
        this.joinableFactory = (JoinableFactory)Preconditions.checkNotNull((Object)joinableFactory, (Object)"joinableFactory");
    }

    public JoinableFactory getJoinableFactory() {
        return this.joinableFactory;
    }

    public static Pair<List<Filter>, List<JoinableClause>> convertJoinsToFilters(List<JoinableClause> clauses, Set<String> requiredColumns, int maxNumFilterValues) {
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        ArrayList<JoinableClause> clausesToUse = new ArrayList<JoinableClause>();
        HashMultiset columnsRequiredByJoinClauses = HashMultiset.create();
        for (JoinableClause clause : clauses) {
            for (String column : clause.getCondition().getRequiredColumns()) {
                columnsRequiredByJoinClauses.add((Object)column, 1);
            }
        }
        Set<String> rightPrefixes = clauses.stream().map(JoinableClause::getPrefix).collect(Collectors.toSet());
        boolean isRightyJoinSeen = false;
        for (JoinableClause clause : clauses) {
            boolean bl = isRightyJoinSeen = isRightyJoinSeen || clause.getJoinType().isRighty();
            if (isRightyJoinSeen) {
                clausesToUse.add(clause);
                continue;
            }
            for (String column : clause.getCondition().getRequiredColumns()) {
                columnsRequiredByJoinClauses.remove((Object)column, 1);
            }
            JoinClauseToFilterConversion joinClauseToFilterConversion = JoinableFactoryWrapper.convertJoinToFilter(clause, (Set<String>)Sets.union(requiredColumns, (Set)columnsRequiredByJoinClauses.elementSet()), maxNumFilterValues, rightPrefixes);
            if (joinClauseToFilterConversion.getConvertedFilter() != null) {
                filterList.add(joinClauseToFilterConversion.getConvertedFilter());
            }
            if (joinClauseToFilterConversion.isJoinClauseFullyConverted()) continue;
            clausesToUse.add(clause);
            for (String column : clause.getCondition().getRequiredColumns()) {
                columnsRequiredByJoinClauses.add((Object)column, 1);
            }
        }
        return Pair.of(filterList, clausesToUse);
    }

    @VisibleForTesting
    static JoinClauseToFilterConversion convertJoinToFilter(JoinableClause clause, Set<String> requiredColumns, int maxNumFilterValues, Set<String> rightPrefixes) {
        List<Equality> equiConditions = clause.getCondition().getEquiConditions();
        if (clause.getJoinType() == JoinType.INNER && clause.getCondition().getNonEquiConditions().isEmpty() && equiConditions.size() == 1) {
            boolean joinClauseFullyConverted = requiredColumns.stream().noneMatch(clause::includesColumn);
            Equality condition = (Equality)CollectionUtils.getOnlyElement(equiConditions, xse -> new IAE("Expected only one equi condition", new Object[0]));
            String leftColumn = condition.getLeftExpr().getBindingIfIdentifier();
            if (leftColumn == null) {
                return new JoinClauseToFilterConversion(null, false);
            }
            if (rightPrefixes.stream().anyMatch(leftColumn::startsWith)) {
                return new JoinClauseToFilterConversion(null, false);
            }
            Joinable.ColumnValuesWithUniqueFlag columnValuesWithUniqueFlag = clause.getJoinable().getMatchableColumnValues(condition.getRightColumn(), condition.isIncludeNull(), maxNumFilterValues);
            if (columnValuesWithUniqueFlag.getColumnValues().isEmpty()) {
                if (columnValuesWithUniqueFlag.isAllUnique()) {
                    return new JoinClauseToFilterConversion(FalseFilter.instance(), true);
                }
                return new JoinClauseToFilterConversion(null, false);
            }
            Filter onlyFilter = Filters.toFilter(new InDimFilter(leftColumn, columnValuesWithUniqueFlag.getColumnValues()));
            if (!columnValuesWithUniqueFlag.isAllUnique()) {
                joinClauseFullyConverted = false;
            }
            return new JoinClauseToFilterConversion(onlyFilter, joinClauseFullyConverted);
        }
        return new JoinClauseToFilterConversion(null, false);
    }

    private static class JoinClauseToFilterConversion {
        @Nullable
        private final Filter convertedFilter;
        private final boolean joinClauseFullyConverted;

        public JoinClauseToFilterConversion(@Nullable Filter convertedFilter, boolean joinClauseFullyConverted) {
            this.convertedFilter = convertedFilter;
            this.joinClauseFullyConverted = joinClauseFullyConverted;
        }

        @Nullable
        public Filter getConvertedFilter() {
            return this.convertedFilter;
        }

        public boolean isJoinClauseFullyConverted() {
            return this.joinClauseFullyConverted;
        }
    }
}

