/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.semantic;

import it.unimi.dsi.fastutil.Arrays;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.druid.query.operator.ColumnWithDirection;
import org.apache.druid.query.rowsandcols.ConcatRowsAndColumns;
import org.apache.druid.query.rowsandcols.EmptyRowsAndColumns;
import org.apache.druid.query.rowsandcols.RearrangedRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.semantic.NaiveSortMaker;

public class DefaultNaiveSortMaker
implements NaiveSortMaker {
    private final RowsAndColumns rac;

    public DefaultNaiveSortMaker(RowsAndColumns rac) {
        this.rac = rac;
    }

    @Override
    public NaiveSortMaker.NaiveSorter make(ArrayList<ColumnWithDirection> ordering) {
        DefaultNaiveSorter retVal = new DefaultNaiveSorter(ordering);
        retVal.moreData(this.rac);
        return retVal;
    }

    private static class DefaultNaiveSorter
    implements NaiveSortMaker.NaiveSorter {
        final ArrayList<RowsAndColumns> racBuffer;
        private final ArrayList<ColumnWithDirection> ordering;

        public DefaultNaiveSorter(ArrayList<ColumnWithDirection> ordering) {
            this.ordering = ordering;
            this.racBuffer = new ArrayList();
        }

        @Override
        @Nullable
        public RowsAndColumns moreData(RowsAndColumns rac) {
            this.racBuffer.add(rac);
            return null;
        }

        @Override
        public RowsAndColumns complete() {
            if (this.racBuffer.isEmpty()) {
                return new EmptyRowsAndColumns();
            }
            RowsAndColumns rac = this.racBuffer.size() == 1 ? this.racBuffer.get(0) : new ConcatRowsAndColumns(this.racBuffer);
            int[] sortedPointers = new int[rac.numRows()];
            for (int i = 0; i < sortedPointers.length; ++i) {
                sortedPointers[i] = i;
            }
            int index = 0;
            int[] direction = new int[this.ordering.size()];
            ColumnAccessor[] accessors = new ColumnAccessor[this.ordering.size()];
            for (ColumnWithDirection orderByColumnSpec : this.ordering) {
                Column col = rac.findColumn(orderByColumnSpec.getColumn());
                if (col == null) continue;
                accessors[index] = col.toAccessor();
                direction[index] = orderByColumnSpec.getDirection().getDirectionInt();
                ++index;
            }
            int numColsToCompare = index;
            Arrays.mergeSort((int)0, (int)rac.numRows(), (k1, k2) -> {
                for (int i = 0; i < numColsToCompare; ++i) {
                    ColumnAccessor accessy = accessors[i];
                    int val = accessy.compareRows(sortedPointers[k1], sortedPointers[k2]);
                    if (val == 0) continue;
                    return val * direction[i];
                }
                return 0;
            }, (a, b) -> {
                int bufPos = sortedPointers[a];
                sortedPointers[a] = sortedPointers[b];
                sortedPointers[b] = bufPos;
            });
            return new RearrangedRowsAndColumns(sortedPointers, rac);
        }
    }
}

