/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.ByteTracker;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.query.rowsandcols.AppendableMapOfColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.concrete.ColumnBasedFrameRowsAndColumns;
import org.apache.druid.query.rowsandcols.concrete.FrameRowsAndColumns;
import org.apache.druid.query.rowsandcols.concrete.RowBasedFrameRowsAndColumns;
import org.apache.druid.query.rowsandcols.semantic.AppendableRowsAndColumns;
import org.apache.druid.segment.column.RowSignature;

public interface RowsAndColumns {
    @Nonnull
    public static AppendableRowsAndColumns expectAppendable(RowsAndColumns input) {
        if (input instanceof AppendableRowsAndColumns) {
            return (AppendableRowsAndColumns)input;
        }
        AppendableRowsAndColumns retVal = input.as(AppendableRowsAndColumns.class);
        if (retVal == null) {
            retVal = new AppendableMapOfColumns(input);
        }
        return retVal;
    }

    public Collection<String> getColumnNames();

    public int numRows();

    @Nullable
    public Column findColumn(String var1);

    @Nullable
    default public <T> T as(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return (T)this;
        }
        return null;
    }

    public static class RowsAndColumnsDeserializer
    extends StdDeserializer<RowsAndColumns> {
        public RowsAndColumnsDeserializer() {
            super(RowsAndColumns.class);
        }

        public FrameRowsAndColumns deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            RowSignature sig = (RowSignature)jsonParser.readValueAs(RowSignature.class);
            jsonParser.nextValue();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            jsonParser.readBinaryValue((OutputStream)baos);
            Frame frame = Frame.wrap(baos.toByteArray());
            if (frame.type().isColumnar()) {
                return new ColumnBasedFrameRowsAndColumns(frame, sig);
            }
            return new RowBasedFrameRowsAndColumns(frame, sig);
        }
    }

    public static class RowsAndColumnsSerializer
    extends StdSerializer<RowsAndColumns> {
        public RowsAndColumnsSerializer() {
            super(RowsAndColumns.class);
        }

        public void serialize(RowsAndColumns rac, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            FrameRowsAndColumns frameRAC = rac.as(FrameRowsAndColumns.class);
            if (frameRAC == null) {
                throw DruidException.defensive("Unable to serialize RAC", new Object[0]);
            }
            JacksonUtils.writeObjectUsingSerializerProvider(jsonGenerator, serializerProvider, frameRAC.getSignature());
            Frame frame = frameRAC.getFrame();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            frame.writeTo(Channels.newChannel(baos), false, null, ByteTracker.unboundedTracker());
            jsonGenerator.writeBinary(baos.toByteArray());
        }
    }
}

