/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window.ranking;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.druid.query.operator.window.Processor;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.column.ColumnAccessorBasedColumn;
import org.apache.druid.query.rowsandcols.semantic.AppendableRowsAndColumns;
import org.apache.druid.segment.column.ColumnType;

public class WindowRowNumberProcessor
implements Processor {
    private final String outputColumn;

    @JsonCreator
    public WindowRowNumberProcessor(@JsonProperty(value="outputColumn") String outputColumn) {
        this.outputColumn = outputColumn;
    }

    @JsonProperty(value="outputColumn")
    public String getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public RowsAndColumns process(final RowsAndColumns incomingPartition) {
        AppendableRowsAndColumns retVal = RowsAndColumns.expectAppendable(incomingPartition);
        retVal.addColumn(this.outputColumn, new ColumnAccessorBasedColumn(new ColumnAccessor(){

            @Override
            public ColumnType getType() {
                return ColumnType.LONG;
            }

            @Override
            public int numRows() {
                return incomingPartition.numRows();
            }

            @Override
            public boolean isNull(int rowNum) {
                return false;
            }

            @Override
            public Object getObject(int rowNum) {
                return this.getInt(rowNum);
            }

            @Override
            public double getDouble(int rowNum) {
                return this.getInt(rowNum);
            }

            @Override
            public float getFloat(int rowNum) {
                return this.getInt(rowNum);
            }

            @Override
            public long getLong(int rowNum) {
                return this.getInt(rowNum);
            }

            @Override
            public int getInt(int rowNum) {
                return rowNum + 1;
            }

            @Override
            public int compareRows(int lhsRowNum, int rhsRowNum) {
                return Integer.compare(lhsRowNum, rhsRowNum);
            }
        }));
        return retVal;
    }

    @Override
    public boolean validateEquivalent(Processor otherProcessor) {
        return otherProcessor instanceof WindowRowNumberProcessor;
    }

    public String toString() {
        return "WindowRowNumberProcessor{outputColumn='" + this.outputColumn + "'}";
    }

    @Override
    public List<String> getOutputColumnNames() {
        return Collections.singletonList(this.outputColumn);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowRowNumberProcessor that = (WindowRowNumberProcessor)o;
        return Objects.equals(this.outputColumn, that.outputColumn);
    }

    public int hashCode() {
        return Objects.hashCode(this.outputColumn);
    }
}

