/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.metadata;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.ChainedExecutionQueryRunner;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.metadata.SegmentAnalyzer;
import org.apache.druid.query.metadata.SegmentMetadataQueryQueryToolChest;
import org.apache.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.druid.query.metadata.metadata.ColumnIncluderator;
import org.apache.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.segment.AggregateProjectionMetadata;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.PhysicalSegmentInspector;
import org.apache.druid.segment.Segment;
import org.joda.time.Interval;

public class SegmentMetadataQueryRunnerFactory
implements QueryRunnerFactory<SegmentAnalysis, SegmentMetadataQuery> {
    private final SegmentMetadataQueryQueryToolChest toolChest;
    private final QueryWatcher queryWatcher;

    @Inject
    public SegmentMetadataQueryRunnerFactory(SegmentMetadataQueryQueryToolChest toolChest, QueryWatcher queryWatcher) {
        this.toolChest = toolChest;
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<SegmentAnalysis> createRunner(final Segment segment) {
        return new QueryRunner<SegmentAnalysis>(){

            @Override
            public Sequence<SegmentAnalysis> run(QueryPlus<SegmentAnalysis> inQ, ResponseContext responseContext) {
                Granularity queryGranularity;
                TimestampSpec timestampSpec;
                HashMap<String, AggregatorFactory> aggregators;
                SegmentMetadataQuery updatedQuery = ((SegmentMetadataQuery)inQ.getQuery()).withFinalizedAnalysisTypes(SegmentMetadataQueryRunnerFactory.this.toolChest.getConfig());
                SegmentAnalyzer analyzer = new SegmentAnalyzer(updatedQuery.getAnalysisTypes());
                Map<String, ColumnAnalysis> analyzedColumns = analyzer.analyze(segment);
                long numRows = analyzer.numRows(segment);
                long totalSize = 0L;
                if (analyzer.analyzingSize()) {
                    totalSize = (long)analyzedColumns.size() * numRows;
                }
                LinkedHashMap<String, ColumnAnalysis> columns = new LinkedHashMap<String, ColumnAnalysis>();
                ColumnIncluderator includerator = updatedQuery.getToInclude();
                for (Map.Entry<String, ColumnAnalysis> entry : analyzedColumns.entrySet()) {
                    String columnName = entry.getKey();
                    AggregatorFactory[] column = entry.getValue();
                    if (!column.isError()) {
                        totalSize += column.getSize();
                    }
                    if (!includerator.include(columnName)) continue;
                    columns.put(columnName, (ColumnAnalysis)column);
                }
                List<Interval> retIntervals = updatedQuery.analyzingInterval() ? Collections.singletonList(segment.getDataInterval()) : null;
                Metadata metadata = null;
                if (updatedQuery.hasAggregators()) {
                    metadata = SegmentMetadataQueryRunnerFactory.this.getMetadata(segment);
                    if (metadata != null && metadata.getAggregators() != null) {
                        aggregators = new HashMap<String, AggregatorFactory>();
                        for (AggregatorFactory aggregator : metadata.getAggregators()) {
                            aggregators.put(aggregator.getName(), aggregator);
                        }
                    } else {
                        aggregators = null;
                    }
                } else {
                    aggregators = null;
                }
                Map<String, AggregateProjectionMetadata> projectionsMap = updatedQuery.hasProjections() && (metadata = Objects.isNull(metadata) ? SegmentMetadataQueryRunnerFactory.this.getMetadata(segment) : metadata) != null && metadata.getProjections() != null ? metadata.getProjections().stream().collect(Collectors.toUnmodifiableMap(projectionMetadata -> projectionMetadata.getSchema().getName(), p -> p)) : null;
                if (updatedQuery.hasTimestampSpec()) {
                    if (metadata == null) {
                        metadata = SegmentMetadataQueryRunnerFactory.this.getMetadata(segment);
                    }
                    timestampSpec = metadata != null ? metadata.getTimestampSpec() : null;
                } else {
                    timestampSpec = null;
                }
                if (updatedQuery.hasQueryGranularity()) {
                    if (metadata == null) {
                        metadata = SegmentMetadataQueryRunnerFactory.this.getMetadata(segment);
                    }
                    queryGranularity = metadata != null ? metadata.getQueryGranularity() : null;
                } else {
                    queryGranularity = null;
                }
                Boolean rollup = null;
                if (updatedQuery.hasRollup()) {
                    if (metadata == null) {
                        metadata = SegmentMetadataQueryRunnerFactory.this.getMetadata(segment);
                    }
                    Boolean bl = rollup = metadata != null ? metadata.isRollup() : null;
                    if (rollup == null) {
                        rollup = Boolean.TRUE;
                    }
                }
                return Sequences.simple(Collections.singletonList(new SegmentAnalysis(segment.getId().toString(), retIntervals, columns, totalSize, numRows, aggregators, projectionsMap, timestampSpec, queryGranularity, rollup)));
            }
        };
    }

    @Override
    public QueryRunner<SegmentAnalysis> mergeRunners(QueryProcessingPool queryProcessingPool, Iterable<QueryRunner<SegmentAnalysis>> queryRunners) {
        return new ChainedExecutionQueryRunner<SegmentAnalysis>(queryProcessingPool, this.queryWatcher, queryRunners);
    }

    @Override
    public QueryToolChest<SegmentAnalysis, SegmentMetadataQuery> getToolchest() {
        return this.toolChest;
    }

    @Nullable
    private Metadata getMetadata(Segment segment) {
        PhysicalSegmentInspector inspector = segment.as(PhysicalSegmentInspector.class);
        if (inspector != null) {
            return inspector.getMetadata();
        }
        return null;
    }
}

