/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.CaseSearchedFunctionVectorProcessor;
import org.apache.druid.math.expr.vector.ExprEvalObjectVector;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;

public final class CaseSearchedObjectVectorProcessor
extends CaseSearchedFunctionVectorProcessor<Object[]> {
    private final Object[] output;

    public CaseSearchedObjectVectorProcessor(ExpressionType outputType, ExprVectorProcessor<?>[] conditionProcessors, ExprVectorProcessor<Object[]>[] whenProcessors) {
        super(outputType, conditionProcessors, whenProcessors);
        this.output = new Object[conditionProcessors[0].maxVectorSize()];
    }

    @Override
    protected void processThenVector(ExprEvalVector<Object[]> thenVector, int currentMatches, int[] thenSelection) {
        Object[] thenValues = thenVector.getObjectVector();
        for (int i = 0; i < currentMatches; ++i) {
            int outIndex = thenSelection[i];
            this.output[outIndex] = thenValues[i];
        }
    }

    @Override
    protected void processElseVector(ExprEvalVector<Object[]> elseVector, int[] conditionSelection) {
        Object[] elseValues = elseVector.getObjectVector();
        for (int i = 0; i < this.conditionBindingFilterer.getCurrentVectorSize(); ++i) {
            int outIndex = conditionSelection[i];
            this.output[outIndex] = elseValues[i];
        }
    }

    @Override
    protected void processElseNull(int[] conditionSelection) {
        for (int i = 0; i < this.conditionBindingFilterer.getCurrentVectorSize(); ++i) {
            int outIndex = conditionSelection[i];
            this.output[outIndex] = null;
        }
    }

    @Override
    protected ExprEvalVector<Object[]> makeResultVector() {
        return new ExprEvalObjectVector(this.output, this.outputType);
    }
}

