/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ConstantExpr;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.VectorProcessors;

class StringExpr
extends ConstantExpr<String> {
    StringExpr(@Nullable String value) {
        super(ExpressionType.STRING, value);
    }

    @Override
    public String toString() {
        return (String)this.value;
    }

    @Override
    protected ExprEval realEval() {
        return ExprEval.ofString((String)this.value);
    }

    @Override
    public <T> ExprVectorProcessor<T> asVectorProcessor(Expr.VectorInputBindingInspector inspector) {
        return VectorProcessors.constant(this.value, inspector.getMaxVectorSize(), ExpressionType.STRING);
    }

    @Override
    public String stringify() {
        return this.value == null ? "null" : StringUtils.format("'%s'", StringEscapeUtils.escapeEcmaScript((String)((String)this.value)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringExpr that = (StringExpr)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

