/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.google.errorprone.annotations.Immutable;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionTypeFactory;
import org.apache.druid.segment.column.BaseTypeSignature;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.column.ValueType;

@Immutable
@JsonSerialize(using=ToStringSerializer.class)
public class ExpressionType
extends BaseTypeSignature<ExprType> {
    public static final ExpressionType STRING = new ExpressionType(ExprType.STRING, null, null);
    public static final ExpressionType LONG = new ExpressionType(ExprType.LONG, null, null);
    public static final ExpressionType DOUBLE = new ExpressionType(ExprType.DOUBLE, null, null);
    public static final ExpressionType STRING_ARRAY = new ExpressionType(ExprType.ARRAY, null, STRING);
    public static final ExpressionType LONG_ARRAY = new ExpressionType(ExprType.ARRAY, null, LONG);
    public static final ExpressionType DOUBLE_ARRAY = new ExpressionType(ExprType.ARRAY, null, DOUBLE);
    public static final ExpressionType NESTED_DATA = ExpressionType.fromColumnTypeStrict(ColumnType.NESTED_DATA);
    public static final ExpressionType UNKNOWN_COMPLEX = new ExpressionType(ExprType.COMPLEX, null, null);

    @JsonCreator
    public ExpressionType(@JsonProperty(value="type") ExprType exprType, @JsonProperty(value="complexTypeName") @Nullable String complexTypeName, @JsonProperty(value="elementType") @Nullable ExpressionType elementType) {
        super(ExpressionTypeFactory.getInstance(), exprType, complexTypeName, elementType);
    }

    @Nullable
    @JsonCreator
    public static ExpressionType fromString(@Nullable String typeName) {
        return Types.fromString(ExpressionTypeFactory.getInstance(), typeName);
    }

    @Nullable
    public static ExpressionType elementType(@Nullable ExpressionType type) {
        if (type != null && type.isArray()) {
            return (ExpressionType)type.getElementType();
        }
        return type;
    }

    @Nullable
    public static ExpressionType asArrayType(@Nullable ExpressionType elementType) {
        if (elementType != null && elementType.isPrimitive()) {
            switch ((ExprType)elementType.getType()) {
                case STRING: {
                    return STRING_ARRAY;
                }
                case LONG: {
                    return LONG_ARRAY;
                }
                case DOUBLE: {
                    return DOUBLE_ARRAY;
                }
            }
        }
        return elementType;
    }

    public static ExpressionType fromColumnTypeStrict(@Nullable TypeSignature<ValueType> valueType) {
        if (valueType == null) {
            throw new IllegalStateException("Unsupported unknown value type");
        }
        switch (valueType.getType()) {
            case LONG: {
                return LONG;
            }
            case FLOAT: 
            case DOUBLE: {
                return DOUBLE;
            }
            case STRING: {
                return STRING;
            }
            case ARRAY: {
                switch (valueType.getElementType().getType()) {
                    case LONG: {
                        return LONG_ARRAY;
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        return DOUBLE_ARRAY;
                    }
                    case STRING: {
                        return STRING_ARRAY;
                    }
                }
                return ExpressionTypeFactory.getInstance().ofArray(ExpressionType.fromColumnTypeStrict(valueType.getElementType()));
            }
            case COMPLEX: {
                return ExpressionTypeFactory.getInstance().ofComplex(valueType.getComplexTypeName());
            }
        }
        throw new ISE("Unsupported value type[%s]", valueType);
    }

    @Nullable
    public static ExpressionType fromColumnType(@Nullable TypeSignature<ValueType> valueType) {
        if (valueType == null) {
            return null;
        }
        switch (valueType.getType()) {
            case LONG: {
                return LONG;
            }
            case FLOAT: 
            case DOUBLE: {
                return DOUBLE;
            }
            case STRING: {
                return STRING;
            }
            case ARRAY: {
                switch (valueType.getElementType().getType()) {
                    case LONG: {
                        return LONG_ARRAY;
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        return DOUBLE_ARRAY;
                    }
                    case STRING: {
                        return STRING_ARRAY;
                    }
                }
                return ExpressionTypeFactory.getInstance().ofArray(ExpressionType.fromColumnType(valueType.getElementType()));
            }
            case COMPLEX: {
                return ExpressionTypeFactory.getInstance().ofComplex(valueType.getComplexTypeName());
            }
        }
        return null;
    }

    public static ColumnType toColumnType(ExpressionType exprType) {
        switch ((ExprType)exprType.getType()) {
            case LONG: {
                return ColumnType.LONG;
            }
            case DOUBLE: {
                return ColumnType.DOUBLE;
            }
            case STRING: {
                return ColumnType.STRING;
            }
            case ARRAY: {
                switch ((ExprType)exprType.getElementType().getType()) {
                    case LONG: {
                        return ColumnType.LONG_ARRAY;
                    }
                    case DOUBLE: {
                        return ColumnType.DOUBLE_ARRAY;
                    }
                    case STRING: {
                        return ColumnType.STRING_ARRAY;
                    }
                }
                return ColumnType.ofArray(ExpressionType.toColumnType((ExpressionType)exprType.getElementType()));
            }
            case COMPLEX: {
                return ColumnType.ofComplex(exprType.getComplexTypeName());
            }
        }
        throw new ISE("Unsupported expression type[%s]", exprType);
    }
}

