/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.lookup;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.lookup.LookupExtractorFactory;
import org.apache.druid.query.lookup.LookupIntrospectHandler;
import org.apache.druid.server.lookup.DataFetcher;
import org.apache.druid.server.lookup.LoadingLookup;
import org.apache.druid.server.lookup.cache.loading.LoadingCache;

@JsonTypeName(value="loadingLookup")
public class LoadingLookupFactory
implements LookupExtractorFactory {
    private static final Logger LOGGER = new Logger(LoadingLookupFactory.class);
    @JsonProperty(value="dataFetcher")
    private final DataFetcher<String, String> dataFetcher;
    @JsonProperty(value="loadingCacheSpec")
    private final LoadingCache<String, String> loadingCache;
    @JsonProperty(value="reverseLoadingCacheSpec")
    private final LoadingCache<String, List<String>> reverseLoadingCache;
    private final String id = Integer.toHexString(System.identityHashCode(this));
    private final LoadingLookup loadingLookup;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public LoadingLookupFactory(@JsonProperty(value="dataFetcher") DataFetcher dataFetcher, @JsonProperty(value="loadingCacheSpec") LoadingCache<String, String> loadingCache, @JsonProperty(value="reverseLoadingCacheSpec") LoadingCache<String, List<String>> reverseLoadingCache) {
        this(dataFetcher, loadingCache, reverseLoadingCache, new LoadingLookup(dataFetcher, loadingCache, reverseLoadingCache));
    }

    protected LoadingLookupFactory(DataFetcher dataFetcher, LoadingCache<String, String> loadingCache, LoadingCache<String, List<String>> reverseLoadingCache, LoadingLookup loadingLookup) {
        this.dataFetcher = (DataFetcher)Preconditions.checkNotNull((Object)dataFetcher);
        this.loadingCache = (LoadingCache)Preconditions.checkNotNull(loadingCache);
        this.reverseLoadingCache = (LoadingCache)Preconditions.checkNotNull(reverseLoadingCache);
        this.loadingLookup = loadingLookup;
    }

    public synchronized boolean start() {
        if (!this.started.get()) {
            this.started.set(this.loadingLookup.isOpen());
            LOGGER.info("created loading lookup with id [%s]", new Object[]{this.id});
        }
        return this.started.get();
    }

    public synchronized boolean close() {
        if (this.started.getAndSet(false)) {
            LOGGER.info("closing loading lookup [%s]", new Object[]{this.id});
            this.loadingLookup.close();
        }
        return !this.started.get();
    }

    public boolean replaces(@Nullable LookupExtractorFactory lookupExtractorFactory) {
        if (lookupExtractorFactory == null) {
            return true;
        }
        return !this.equals(lookupExtractorFactory);
    }

    @Nullable
    public LookupIntrospectHandler getIntrospectHandler() {
        return null;
    }

    public void awaitInitialization() {
    }

    public boolean isInitialized() {
        return true;
    }

    public LoadingLookup get() {
        return this.loadingLookup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LoadingLookupFactory)) {
            return false;
        }
        LoadingLookupFactory that = (LoadingLookupFactory)o;
        if (this.dataFetcher != null ? !this.dataFetcher.equals(that.dataFetcher) : that.dataFetcher != null) {
            return false;
        }
        if (this.loadingCache != null ? !this.loadingCache.equals(that.loadingCache) : that.loadingCache != null) {
            return false;
        }
        return this.reverseLoadingCache != null ? this.reverseLoadingCache.equals(that.reverseLoadingCache) : that.reverseLoadingCache == null;
    }

    public int hashCode() {
        return Objects.hash(this.dataFetcher, this.loadingCache, this.reverseLoadingCache);
    }
}

