/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.stage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.msq.input.SlicerUtils;
import org.apache.druid.msq.input.stage.ReadablePartition;
import org.apache.druid.msq.input.stage.ReadablePartitions;

public class StripedReadablePartitions
implements ReadablePartitions {
    private final int stageNumber;
    private final int numWorkers;
    private final IntSortedSet partitionNumbers;

    public StripedReadablePartitions(int stageNumber, int numWorkers, IntSortedSet partitionNumbers) {
        this.stageNumber = stageNumber;
        this.numWorkers = numWorkers;
        this.partitionNumbers = partitionNumbers;
    }

    @JsonCreator
    private StripedReadablePartitions(@JsonProperty(value="stageNumber") int stageNumber, @JsonProperty(value="numWorkers") int numWorkers, @JsonProperty(value="partitionNumbers") Set<Integer> partitionNumbers) {
        this(stageNumber, numWorkers, (IntSortedSet)new IntAVLTreeSet(partitionNumbers));
    }

    @Override
    public Iterator<ReadablePartition> iterator() {
        return Iterators.transform((Iterator)this.partitionNumbers.iterator(), partitionNumber -> ReadablePartition.striped(this.stageNumber, this.numWorkers, (int)partitionNumber));
    }

    @Override
    public List<ReadablePartitions> split(int maxNumSplits) {
        ArrayList<ReadablePartitions> retVal = new ArrayList<ReadablePartitions>();
        for (List entries : SlicerUtils.makeSlicesStatic(this.partitionNumbers.iterator(), maxNumSplits)) {
            if (entries.isEmpty()) continue;
            retVal.add(new StripedReadablePartitions(this.stageNumber, this.numWorkers, (IntSortedSet)new IntAVLTreeSet(entries)));
        }
        return retVal;
    }

    @JsonProperty
    int getStageNumber() {
        return this.stageNumber;
    }

    @JsonProperty
    int getNumWorkers() {
        return this.numWorkers;
    }

    @JsonProperty
    IntSortedSet getPartitionNumbers() {
        return this.partitionNumbers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StripedReadablePartitions that = (StripedReadablePartitions)o;
        return this.stageNumber == that.stageNumber && this.numWorkers == that.numWorkers && Objects.equals(this.partitionNumbers, that.partitionNumbers);
    }

    public int hashCode() {
        return Objects.hash(this.stageNumber, this.numWorkers, this.partitionNumbers);
    }

    public String toString() {
        return "StripedReadablePartitions{stageNumber=" + this.stageNumber + ", numWorkers=" + this.numWorkers + ", partitionNumbers=" + this.partitionNumbers + "}";
    }
}

