/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.worker;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import it.unimi.dsi.fastutil.Pair;
import java.io.Closeable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.msq.dart.worker.DartWorkerClient;
import org.apache.druid.msq.dart.worker.DartWorkerRetryPolicy;
import org.apache.druid.msq.dart.worker.WorkerId;
import org.apache.druid.msq.rpc.BaseWorkerClientImpl;
import org.apache.druid.rpc.FixedServiceLocator;
import org.apache.druid.rpc.IgnoreHttpResponseHandler;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.ServiceLocation;
import org.apache.druid.rpc.ServiceLocator;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.utils.CloseableUtils;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class DartWorkerClientImpl
extends BaseWorkerClientImpl
implements DartWorkerClient {
    private static final Logger log = new Logger(DartWorkerClientImpl.class);
    private final String queryId;
    private final ServiceClientFactory clientFactory;
    private final ServiceRetryPolicy retryPolicy;
    @Nullable
    private final String controllerHost;
    @GuardedBy(value="clientMap")
    private final Map<String, Pair<ServiceClient, Closeable>> clientMap = new HashMap<String, Pair<ServiceClient, Closeable>>();

    public DartWorkerClientImpl(String queryId, ServiceClientFactory clientFactory, ObjectMapper smileMapper, @Nullable String controllerHost) {
        super(smileMapper, "application/x-jackson-smile");
        this.queryId = queryId;
        this.clientFactory = clientFactory;
        this.controllerHost = controllerHost;
        this.retryPolicy = controllerHost == null ? new DartWorkerRetryPolicy(true) : new DartWorkerRetryPolicy(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ServiceClient getClient(String workerIdString) {
        WorkerId workerId = WorkerId.fromString(workerIdString);
        if (!this.queryId.equals(workerId.getQueryId())) {
            throw DruidException.defensive((String)"Unexpected queryId[%s]. Expected queryId[%s]", (Object[])new Object[]{workerId.getQueryId(), this.queryId});
        }
        Map<String, Pair<ServiceClient, Closeable>> map = this.clientMap;
        synchronized (map) {
            return (ServiceClient)this.clientMap.computeIfAbsent(workerId.getHostAndPort(), ignored -> this.makeNewClient(workerId)).left();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeClient(String workerHost) {
        Map<String, Pair<ServiceClient, Closeable>> map = this.clientMap;
        synchronized (map) {
            Pair<ServiceClient, Closeable> clientPair = this.clientMap.remove(workerHost);
            if (clientPair != null) {
                CloseableUtils.closeAndWrapExceptions((Closeable)((Closeable)clientPair.right()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<String, Pair<ServiceClient, Closeable>> map = this.clientMap;
        synchronized (map) {
            for (Map.Entry<String, Pair<ServiceClient, Closeable>> entry : this.clientMap.entrySet()) {
                CloseableUtils.closeAndSuppressExceptions((Closeable)((Closeable)entry.getValue().right()), e -> log.warn(e, "Failed to close client[%s]", new Object[]{entry.getKey()}));
            }
            this.clientMap.clear();
        }
    }

    @Override
    public ListenableFuture<?> stopWorker(String workerId) {
        return this.getClient(workerId).asyncRequest(new RequestBuilder(HttpMethod.POST, "/stop"), (HttpResponseHandler)IgnoreHttpResponseHandler.INSTANCE);
    }

    protected Pair<ServiceClient, Closeable> makeNewClient(WorkerId workerId) {
        URI uri = workerId.toUri();
        FixedServiceLocator locator = new FixedServiceLocator(ServiceLocation.fromUri((URI)uri));
        ServiceClient baseClient = this.clientFactory.makeClient(workerId.toString(), (ServiceLocator)locator, this.retryPolicy);
        ServiceClient client = this.controllerHost != null ? new ControllerDecoratedClient(baseClient, this.controllerHost) : baseClient;
        return Pair.of((Object)client, (Object)locator);
    }

    private static class ControllerDecoratedClient
    implements ServiceClient {
        private final ServiceClient delegate;
        private final String controllerHost;

        ControllerDecoratedClient(ServiceClient delegate, String controllerHost) {
            this.delegate = delegate;
            this.controllerHost = controllerHost;
        }

        public <IntermediateType, FinalType> ListenableFuture<FinalType> asyncRequest(RequestBuilder requestBuilder, HttpResponseHandler<IntermediateType, FinalType> handler) {
            return this.delegate.asyncRequest(requestBuilder.header("X-Dart-Controller-Host", this.controllerHost), handler);
        }

        public ServiceClient withRetryPolicy(ServiceRetryPolicy retryPolicy) {
            return new ControllerDecoratedClient(this.delegate.withRetryPolicy(retryPolicy), this.controllerHost);
        }
    }
}

