/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller;

import java.util.ArrayList;
import java.util.List;
import org.apache.druid.msq.dart.worker.DartQueryableSegment;
import org.apache.druid.msq.input.table.DataServerRequestDescriptor;

public class DartSegmentAssignment {
    private final List<DartQueryableSegment> dartQueryableSegments;
    private final List<DataServerRequestDescriptor> dataServerRequestDescriptor;

    public DartSegmentAssignment(List<DartQueryableSegment> dartQueryableSegments, List<DataServerRequestDescriptor> dataServerRequestDescriptor) {
        this.dartQueryableSegments = dartQueryableSegments;
        this.dataServerRequestDescriptor = dataServerRequestDescriptor;
    }

    public static DartSegmentAssignment empty() {
        return new DartSegmentAssignment(new ArrayList<DartQueryableSegment>(), new ArrayList<DataServerRequestDescriptor>());
    }

    public void addSegments(DartQueryableSegment segment) {
        this.dartQueryableSegments.add(segment);
    }

    public void addRequest(DataServerRequestDescriptor requestDescriptor) {
        this.dataServerRequestDescriptor.add(requestDescriptor);
    }

    public List<DartQueryableSegment> getDartQueryableSegments() {
        return this.dartQueryableSegments;
    }

    public List<DataServerRequestDescriptor> getDataServerRequestDescriptor() {
        return this.dataServerRequestDescriptor;
    }

    public boolean isEmpty() {
        return this.dataServerRequestDescriptor.isEmpty() && this.dartQueryableSegments.isEmpty();
    }
}

