/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.druid.annotations.SuppressFBWarnings;
import org.apache.druid.indexer.DataSegmentAndIndexZipFilePath;
import org.apache.druid.indexer.HadoopDruidDetermineConfigurationJob;
import org.apache.druid.indexer.HadoopDruidIndexerConfig;
import org.apache.druid.indexer.HadoopDruidIndexerJob;
import org.apache.druid.indexer.HadoopIngestionSpec;
import org.apache.druid.indexer.HadoopTask;
import org.apache.druid.indexer.HadoopTaskConfig;
import org.apache.druid.indexer.IngestionState;
import org.apache.druid.indexer.JobHelper;
import org.apache.druid.indexer.OverlordActionBasedUsedSegmentsRetriever;
import org.apache.druid.indexer.TaskMetricsGetter;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.granularity.ArbitraryGranularitySpec;
import org.apache.druid.indexer.granularity.GranularitySpec;
import org.apache.druid.indexer.path.SegmentMetadataPublisher;
import org.apache.druid.indexer.report.TaskReport;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TimeChunkLockAcquireAction;
import org.apache.druid.indexing.common.actions.TimeChunkLockTryAcquireAction;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.Tasks;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.realtime.ChatHandler;
import org.apache.druid.segment.realtime.ChatHandlerProvider;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.timeline.DataSegment;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.joda.time.Interval;

@SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION", "NP_STORE_INTO_NONNULL_FIELD"})
public class HadoopIndexTask
extends HadoopTask
implements ChatHandler {
    public static final String TYPE = "index_hadoop";
    public static final String INPUT_SOURCE_TYPE = "hadoop";
    private static final Logger log = new Logger(HadoopIndexTask.class);
    private static final String HADOOP_JOB_ID_FILENAME = "mapReduceJobId.json";
    private TaskConfig taskConfig = null;
    @JsonIgnore
    private HadoopIngestionSpec spec;
    @JsonIgnore
    private final String classpathPrefix;
    @JsonIgnore
    private final ObjectMapper jsonMapper;
    @JsonIgnore
    private final AuthorizerMapper authorizerMapper;
    @JsonIgnore
    private final HadoopTaskConfig hadoopTaskConfig;
    @JsonIgnore
    private final Optional<ChatHandlerProvider> chatHandlerProvider;
    @JsonIgnore
    private InnerProcessingStatsGetter determinePartitionsStatsGetter;
    @JsonIgnore
    private InnerProcessingStatsGetter buildSegmentsStatsGetter;
    @JsonIgnore
    private IngestionState ingestionState;
    @JsonIgnore
    private HadoopDetermineConfigInnerProcessingStatus determineConfigStatus = null;
    @JsonIgnore
    private HadoopIndexGeneratorInnerProcessingStatus buildSegmentsStatus = null;
    @JsonIgnore
    private String errorMsg;

    private static String getTheDataSource(HadoopIngestionSpec spec) {
        return spec.getDataSchema().getDataSource();
    }

    @JsonCreator
    public HadoopIndexTask(@JsonProperty(value="id") String id, @JsonProperty(value="spec") HadoopIngestionSpec spec, @JsonProperty(value="hadoopCoordinates") String hadoopCoordinates, @JsonProperty(value="hadoopDependencyCoordinates") List<String> hadoopDependencyCoordinates, @JsonProperty(value="classpathPrefix") String classpathPrefix, @JacksonInject ObjectMapper jsonMapper, @JsonProperty(value="context") Map<String, Object> context, @JacksonInject AuthorizerMapper authorizerMapper, @JacksonInject ChatHandlerProvider chatHandlerProvider, @JacksonInject HadoopTaskConfig hadoopTaskConfig) {
        super(AbstractTask.getOrMakeId((String)id, (String)TYPE, (String)HadoopIndexTask.getTheDataSource(spec)), HadoopIndexTask.getTheDataSource(spec), (List<String>)(hadoopDependencyCoordinates == null ? (hadoopCoordinates == null ? null : ImmutableList.of((Object)hadoopCoordinates)) : hadoopDependencyCoordinates), context, hadoopTaskConfig);
        this.authorizerMapper = authorizerMapper;
        this.chatHandlerProvider = Optional.fromNullable((Object)chatHandlerProvider);
        this.spec = context == null ? spec : spec.withContext(context);
        Preconditions.checkArgument((this.spec.getIOConfig().getSegmentOutputPath() == null ? 1 : 0) != 0, (Object)"segmentOutputPath must be absent");
        Preconditions.checkArgument((this.spec.getTuningConfig().getWorkingPath() == null ? 1 : 0) != 0, (Object)"workingPath must be absent");
        Preconditions.checkArgument((this.spec.getIOConfig().getMetadataUpdateSpec() == null ? 1 : 0) != 0, (Object)"metadataUpdateSpec must be absent");
        this.hadoopTaskConfig = hadoopTaskConfig;
        this.classpathPrefix = classpathPrefix;
        this.jsonMapper = (ObjectMapper)Preconditions.checkNotNull((Object)jsonMapper, (Object)"null ObjectMappper");
        this.ingestionState = IngestionState.NOT_STARTED;
    }

    public String getType() {
        return TYPE;
    }

    @Nonnull
    @JsonIgnore
    public Set<ResourceAction> getInputSourceResources() {
        return Set.of(AuthorizationUtils.createExternalResourceReadAction((String)INPUT_SOURCE_TYPE));
    }

    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        Iterable intervals = this.spec.getDataSchema().getGranularitySpec().sortedBucketIntervals();
        if (intervals.iterator().hasNext()) {
            Interval interval = JodaUtils.umbrellaInterval((Iterable)JodaUtils.condenseIntervals((Iterable)intervals));
            TaskLock lock = (TaskLock)taskActionClient.submit((TaskAction)new TimeChunkLockTryAcquireAction(TaskLockType.EXCLUSIVE, interval));
            if (lock == null) {
                return false;
            }
            lock.assertNotRevoked();
            return true;
        }
        return true;
    }

    public boolean requireLockExistingSegments() {
        throw new UnsupportedOperationException();
    }

    public List<DataSegment> findSegmentsToLock(TaskActionClient taskActionClient, List<Interval> intervals) {
        throw new UnsupportedOperationException();
    }

    public boolean isPerfectRollup() {
        return true;
    }

    @Nullable
    public Granularity getSegmentGranularity() {
        GranularitySpec granularitySpec = this.spec.getDataSchema().getGranularitySpec();
        if (granularitySpec instanceof ArbitraryGranularitySpec) {
            return null;
        }
        return granularitySpec.getSegmentGranularity();
    }

    @JsonProperty(value="spec")
    public HadoopIngestionSpec getSpec() {
        return this.spec;
    }

    @Override
    @JsonProperty
    public List<String> getHadoopDependencyCoordinates() {
        return super.getHadoopDependencyCoordinates();
    }

    @JsonProperty
    public String getClasspathPrefix() {
        return this.classpathPrefix;
    }

    private String getHadoopJobIdFileName() {
        return this.getHadoopJobIdFile().getAbsolutePath();
    }

    private boolean hadoopJobIdFileExists() {
        return this.getHadoopJobIdFile().exists();
    }

    private File getHadoopJobIdFile() {
        return new File(this.taskConfig.getTaskDir(this.getId()), HADOOP_JOB_ID_FILENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskStatus runTask(TaskToolbox toolbox) {
        try {
            this.taskConfig = toolbox.getConfig();
            if (!this.taskConfig.isAllowHadoopTaskExecution()) {
                this.errorMsg = StringUtils.format((String)"Hadoop tasks are deprecated and will be removed in a future release. Currently, they are not allowed to run on this cluster. If you wish to run them despite deprecation, please set [%s] to true.", (Object[])new Object[]{"druid.indexer.task.allowHadoopTaskExecution"});
                log.error(this.errorMsg, new Object[0]);
                toolbox.getTaskReportFileWriter().write(this.getId(), this.getTaskCompletionReports());
                TaskStatus taskStatus = TaskStatus.failure((String)this.getId(), (String)this.errorMsg);
                return taskStatus;
            }
            log.warn("Running deprecated index_hadoop task [%s]. Hadoop batch indexing is deprecated and will be removed in a future release. Please plan your migration to one of Druid's supported indexing patterns.", new Object[]{this.getId()});
            if (this.chatHandlerProvider.isPresent()) {
                log.info("Found chat handler of class[%s]", new Object[]{((ChatHandlerProvider)this.chatHandlerProvider.get()).getClass().getName()});
                ((ChatHandlerProvider)this.chatHandlerProvider.get()).register(this.getId(), (ChatHandler)this, false);
            } else {
                log.warn("No chat handler detected", new Object[0]);
            }
            TaskStatus taskStatus = this.runInternal(toolbox);
            return taskStatus;
        }
        catch (Exception e) {
            Throwable effectiveException;
            if (e instanceof RuntimeException && e.getCause() instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)e.getCause();
                effectiveException = ite.getCause();
                log.error(effectiveException, "Got invocation target exception in run()", new Object[0]);
            } else {
                effectiveException = e;
                log.error((Throwable)e, "Encountered exception in run()", new Object[0]);
            }
            this.errorMsg = Throwables.getStackTraceAsString((Throwable)effectiveException);
            toolbox.getTaskReportFileWriter().write(this.getId(), this.getTaskCompletionReports());
            TaskStatus taskStatus = TaskStatus.failure((String)this.getId(), (String)this.errorMsg);
            return taskStatus;
        }
        finally {
            if (this.chatHandlerProvider.isPresent()) {
                ((ChatHandlerProvider)this.chatHandlerProvider.get()).unregister(this.getId());
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TaskStatus runInternal(TaskToolbox toolbox) throws Exception {
        indexGeneratorJobAttempted = false;
        indexGeneratorJobSuccess = false;
        indexerSchema = null;
        this.registerResourceCloserOnAbnormalExit((Consumer<TaskConfig>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$runInternal$0(org.apache.druid.indexing.common.config.TaskConfig ), (Lorg/apache/druid/indexing/common/config/TaskConfig;)V)((HadoopIndexTask)this));
        hadoopJobIdFile = this.getHadoopJobIdFileName();
        HadoopTask.logExtensionsConfig();
        loader = this.buildClassLoader();
        determineIntervals = this.spec.getDataSchema().getGranularitySpec().inputIntervals().isEmpty();
        HadoopIngestionSpec.updateSegmentListIfDatasourcePathSpecIsUsed(this.spec, this.jsonMapper, new OverlordActionBasedUsedSegmentsRetriever(toolbox));
        determinePartitionsInnerProcessingRunner = HadoopTask.getForeignClassloaderObject("org.apache.druid.indexer.HadoopIndexTask$HadoopDetermineConfigInnerProcessingRunner", loader);
        this.determinePartitionsStatsGetter = new InnerProcessingStatsGetter(determinePartitionsInnerProcessingRunner);
        determinePartitionsInput = new String[]{toolbox.getJsonMapper().writeValueAsString((Object)this.spec), this.hadoopTaskConfig.getHadoopWorkingPath(), toolbox.getSegmentPusher().getPathForHadoop(), hadoopJobIdFile};
        oldLoader = Thread.currentThread().getContextClassLoader();
        determinePartitionsRunnerClass = determinePartitionsInnerProcessingRunner.getClass();
        determinePartitionsInnerProcessingRunTask = determinePartitionsRunnerClass.getMethod("runTask", new Class[]{determinePartitionsInput.getClass()});
        try {
            Thread.currentThread().setContextClassLoader(loader);
            this.ingestionState = IngestionState.DETERMINE_PARTITIONS;
            determineConfigStatusString = (String)determinePartitionsInnerProcessingRunTask.invoke(determinePartitionsInnerProcessingRunner, new Object[]{determinePartitionsInput});
            this.determineConfigStatus = (HadoopDetermineConfigInnerProcessingStatus)toolbox.getJsonMapper().readValue(determineConfigStatusString, HadoopDetermineConfigInnerProcessingStatus.class);
            indexerSchema = this.determineConfigStatus.getSchema();
            if (indexerSchema == null) {
                this.errorMsg = this.determineConfigStatus.getErrorMsg();
                toolbox.getTaskReportFileWriter().write(this.getId(), this.getTaskCompletionReports());
                var14_15 = TaskStatus.failure((String)this.getId(), (String)this.errorMsg);
                return var14_15;
            }
            ** GOTO lbl40
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        {
            block24: {
                catch (Throwable var24_33) {
                    this.indexerGeneratorCleanupJob(indexGeneratorJobAttempted, indexGeneratorJobSuccess, indexerSchema == null ? null : toolbox.getJsonMapper().writeValueAsString(indexerSchema));
                    throw var24_33;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldLoader);
                }
lbl40:
                // 1 sources

                Thread.currentThread().setContextClassLoader(oldLoader);
                if (determineIntervals) {
                    interval = JodaUtils.umbrellaInterval((Iterable)JodaUtils.condenseIntervals((Iterable)indexerSchema.getDataSchema().getGranularitySpec().sortedBucketIntervals()));
                    lockTimeoutMs = (Long)this.getContextValue("taskLockTimeout", Tasks.DEFAULT_LOCK_TIMEOUT_MILLIS);
                    lock = (TaskLock)Preconditions.checkNotNull((Object)((TaskLock)toolbox.getTaskActionClient().submit((TaskAction)new TimeChunkLockAcquireAction(TaskLockType.EXCLUSIVE, interval, lockTimeoutMs))), (String)"Cannot acquire a lock for interval[%s]", (Object)interval);
                    lock.assertNotRevoked();
                    version = lock.getVersion();
                } else {
                    locks = AbstractTask.getTaskLocks((TaskActionClient)toolbox.getTaskActionClient());
                    myLock = (TaskLock)Iterables.getOnlyElement((Iterable)locks);
                    version = myLock.getVersion();
                }
                specVersion = indexerSchema.getTuningConfig().getVersion();
                if (indexerSchema.getTuningConfig().isUseExplicitVersion()) {
                    if (specVersion.compareTo(version) < 0) {
                        version = specVersion;
                    } else {
                        errMsg = StringUtils.format((String)"Spec version can not be greater than or equal to the lock version, Spec version: [%s] Lock version: [%s].", (Object[])new Object[]{specVersion, version});
                        HadoopIndexTask.log.error(errMsg, new Object[0]);
                        toolbox.getTaskReportFileWriter().write(this.getId(), null);
                        var16_23 = TaskStatus.failure((String)this.getId(), (String)errMsg);
                        this.indexerGeneratorCleanupJob(indexGeneratorJobAttempted, indexGeneratorJobSuccess, indexerSchema == null ? null : toolbox.getJsonMapper().writeValueAsString((Object)indexerSchema));
                        return var16_23;
                    }
                }
                HadoopIndexTask.log.info("Setting version to: %s", new Object[]{version});
                innerProcessingRunner = HadoopTask.getForeignClassloaderObject("org.apache.druid.indexer.HadoopIndexTask$HadoopIndexGeneratorInnerProcessingRunner", loader);
                this.buildSegmentsStatsGetter = new InnerProcessingStatsGetter(innerProcessingRunner);
                buildSegmentsInput = new String[]{toolbox.getJsonMapper().writeValueAsString((Object)indexerSchema), version, hadoopJobIdFile};
                buildSegmentsRunnerClass = innerProcessingRunner.getClass();
                innerProcessingRunTask = buildSegmentsRunnerClass.getMethod("runTask", new Class[]{buildSegmentsInput.getClass()});
                Thread.currentThread().setContextClassLoader(loader);
                this.ingestionState = IngestionState.BUILD_SEGMENTS;
                indexGeneratorJobAttempted = true;
                jobStatusString = (String)innerProcessingRunTask.invoke(innerProcessingRunner, new Object[]{buildSegmentsInput});
                this.buildSegmentsStatus = (HadoopIndexGeneratorInnerProcessingStatus)toolbox.getJsonMapper().readValue(jobStatusString, HadoopIndexGeneratorInnerProcessingStatus.class);
                dataSegmentAndIndexZipFilePaths = this.buildSegmentsStatus.getDataSegmentAndIndexZipFilePaths();
                if (dataSegmentAndIndexZipFilePaths == null) break block24;
                indexGeneratorJobSuccess = true;
                this.renameSegmentIndexFilesJob(toolbox.getJsonMapper().writeValueAsString((Object)indexerSchema), toolbox.getJsonMapper().writeValueAsString(dataSegmentAndIndexZipFilePaths));
                segments = new ArrayList<E>(dataSegmentAndIndexZipFilePaths.stream().map((Function<DataSegmentAndIndexZipFilePath, DataSegment>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getSegment(), (Lorg/apache/druid/indexer/DataSegmentAndIndexZipFilePath;)Lorg/apache/druid/timeline/DataSegment;)()).collect(Collectors.toList()));
                toolbox.publishSegments(segments);
                if (this.spec.getTuningConfig().getAwaitSegmentAvailabilityTimeoutMillis() > 0L) {
                    this.ingestionState = IngestionState.SEGMENT_AVAILABILITY_WAIT;
                    this.waitForSegmentAvailability(toolbox, segments, this.spec.getTuningConfig().getAwaitSegmentAvailabilityTimeoutMillis());
                }
                this.ingestionState = IngestionState.COMPLETED;
                toolbox.getTaskReportFileWriter().write(this.getId(), this.getTaskCompletionReports());
                var22_31 = TaskStatus.success((String)this.getId());
                Thread.currentThread().setContextClassLoader(oldLoader);
                this.indexerGeneratorCleanupJob(indexGeneratorJobAttempted, indexGeneratorJobSuccess, indexerSchema == null ? null : toolbox.getJsonMapper().writeValueAsString((Object)indexerSchema));
                return var22_31;
            }
            try {
                this.errorMsg = this.buildSegmentsStatus.getErrorMsg();
                toolbox.getTaskReportFileWriter().write(this.getId(), this.getTaskCompletionReports());
                var21_30 = TaskStatus.failure((String)this.getId(), (String)this.errorMsg);
                return var21_30;
            }
            catch (Exception e) {}
            {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable var23_32) {
            throw var23_32;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    private void killHadoopJob() {
        if (this.hadoopJobIdFileExists() && !this.ingestionState.equals((Object)IngestionState.COMPLETED)) {
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            String hadoopJobIdFile = this.getHadoopJobIdFileName();
            try {
                ClassLoader loader = HadoopTask.buildClassLoader(this.getHadoopDependencyCoordinates(), this.hadoopTaskConfig.getDefaultHadoopCoordinates());
                Object killMRJobInnerProcessingRunner = HadoopTask.getForeignClassloaderObject("org.apache.druid.indexer.HadoopIndexTask$HadoopKillMRJobIdProcessingRunner", loader);
                String[] buildKillJobInput = new String[]{hadoopJobIdFile};
                Class<?> buildKillJobRunnerClass = killMRJobInnerProcessingRunner.getClass();
                Method innerProcessingRunTask = buildKillJobRunnerClass.getMethod("runTask", buildKillJobInput.getClass());
                Thread.currentThread().setContextClassLoader(loader);
                String[] killStatusString = (String[])innerProcessingRunTask.invoke(killMRJobInnerProcessingRunner, new Object[]{buildKillJobInput});
                log.info(StringUtils.format((String)"Tried killing job: [%s], status: [%s]", (Object[])new Object[]{killStatusString[0], killStatusString[1]}), new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
    }

    private void renameSegmentIndexFilesJob(String hadoopIngestionSpecStr, String dataSegmentAndIndexZipFilePathListStr) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = loader.loadClass("org.apache.druid.indexer.HadoopIndexTask$HadoopRenameSegmentIndexFilesRunner");
            Object renameSegmentIndexFilesRunner = clazz.newInstance();
            String[] renameSegmentIndexFilesJobInput = new String[]{hadoopIngestionSpecStr, dataSegmentAndIndexZipFilePathListStr};
            Class<?> buildRenameSegmentIndexFilesJobRunnerClass = renameSegmentIndexFilesRunner.getClass();
            Method renameSegmentIndexFiles = buildRenameSegmentIndexFilesJobRunnerClass.getMethod("runTask", renameSegmentIndexFilesJobInput.getClass());
            renameSegmentIndexFiles.invoke(renameSegmentIndexFilesRunner, new Object[]{renameSegmentIndexFilesJobInput});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexerGeneratorCleanupJob(boolean indexGeneratorJobAttempted, boolean indexGeneratorJobSuccess, String hadoopIngestionSpecStr) {
        if (!indexGeneratorJobAttempted) {
            log.info("No need for cleanup as index generator job did not even run", new Object[0]);
            return;
        }
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader loader = HadoopTask.buildClassLoader(this.getHadoopDependencyCoordinates(), this.hadoopTaskConfig.getDefaultHadoopCoordinates());
            Object indexerGeneratorCleanupRunner = HadoopTask.getForeignClassloaderObject("org.apache.druid.indexer.HadoopIndexTask$HadoopIndexerGeneratorCleanupRunner", loader);
            String[] indexerGeneratorCleanupJobInput = new String[]{indexGeneratorJobSuccess ? "true" : "false", hadoopIngestionSpecStr};
            Class<?> buildIndexerGeneratorCleanupRunnerClass = indexerGeneratorCleanupRunner.getClass();
            Method indexerGeneratorCleanup = buildIndexerGeneratorCleanupRunnerClass.getMethod("runTask", indexerGeneratorCleanupJobInput.getClass());
            Thread.currentThread().setContextClassLoader(loader);
            indexerGeneratorCleanup.invoke(indexerGeneratorCleanupRunner, new Object[]{indexerGeneratorCleanupJobInput});
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to cleanup after index generator job", new Object[0]);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    @GET
    @Path(value="/rowStats")
    @Produces(value={"application/json"})
    public Response getRowStats(@Context HttpServletRequest req, @QueryParam(value="windows") List<Integer> windows) {
        AuthorizationUtils.verifyUnrestrictedAccessToDatasource((HttpServletRequest)req, (String)this.getDataSource(), (AuthorizerMapper)this.authorizerMapper);
        HashMap<String, Map<String, Number>> totalsMap = new HashMap<String, Map<String, Number>>();
        if (this.determinePartitionsStatsGetter != null) {
            totalsMap.put("determinePartitions", this.determinePartitionsStatsGetter.getTotalMetrics());
        }
        if (this.buildSegmentsStatsGetter != null) {
            totalsMap.put("buildSegments", this.buildSegmentsStatsGetter.getTotalMetrics());
        }
        return Response.ok(Map.of("totals", totalsMap)).build();
    }

    private TaskReport.ReportMap getTaskCompletionReports() {
        return this.buildIngestionStatsAndContextReport(this.ingestionState, this.errorMsg, null, null);
    }

    protected Map<String, Object> getTaskCompletionRowStats() {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        if (this.determineConfigStatus != null) {
            metrics.put("determinePartitions", this.determineConfigStatus.getMetrics());
        }
        if (this.buildSegmentsStatus != null) {
            metrics.put("buildSegments", this.buildSegmentsStatus.getMetrics());
        }
        return metrics;
    }

    private /* synthetic */ void lambda$runInternal$0(TaskConfig config) {
        this.killHadoopJob();
    }

    public static class HadoopDetermineConfigInnerProcessingStatus {
        private final HadoopIngestionSpec schema;
        private final Map<String, Object> metrics;
        private final String errorMsg;

        @JsonCreator
        public HadoopDetermineConfigInnerProcessingStatus(@JsonProperty(value="schema") HadoopIngestionSpec schema, @JsonProperty(value="metrics") Map<String, Object> metrics, @JsonProperty(value="errorMsg") String errorMsg) {
            this.schema = schema;
            this.metrics = metrics;
            this.errorMsg = errorMsg;
        }

        @JsonProperty
        public HadoopIngestionSpec getSchema() {
            return this.schema;
        }

        @JsonProperty
        public Map<String, Object> getMetrics() {
            return this.metrics;
        }

        @JsonProperty
        public String getErrorMsg() {
            return this.errorMsg;
        }
    }

    public static class HadoopIndexGeneratorInnerProcessingStatus {
        private final List<DataSegmentAndIndexZipFilePath> dataSegmentAndIndexZipFilePaths;
        private final Map<String, Object> metrics;
        private final String errorMsg;

        @JsonCreator
        public HadoopIndexGeneratorInnerProcessingStatus(@JsonProperty(value="dataSegmentAndIndexZipFilePaths") List<DataSegmentAndIndexZipFilePath> dataSegmentAndIndexZipFilePaths, @JsonProperty(value="metrics") Map<String, Object> metrics, @JsonProperty(value="errorMsg") String errorMsg) {
            this.dataSegmentAndIndexZipFilePaths = dataSegmentAndIndexZipFilePaths;
            this.metrics = metrics;
            this.errorMsg = errorMsg;
        }

        @JsonProperty
        public List<DataSegmentAndIndexZipFilePath> getDataSegmentAndIndexZipFilePaths() {
            return this.dataSegmentAndIndexZipFilePaths;
        }

        @JsonProperty
        public Map<String, Object> getMetrics() {
            return this.metrics;
        }

        @JsonProperty
        public String getErrorMsg() {
            return this.errorMsg;
        }
    }

    public static class InnerProcessingStatsGetter
    implements TaskMetricsGetter {
        static final List<String> KEYS = ImmutableList.of((Object)"rowsProcessed", (Object)"rowsProcessedWithErrors", (Object)"rowsThrownAway", (Object)"rowsUnparseable");
        private final Method getStatsMethod;
        private final Object innerProcessingRunner;

        public InnerProcessingStatsGetter(Object innerProcessingRunner) {
            try {
                Class<?> aClazz = innerProcessingRunner.getClass();
                this.getStatsMethod = aClazz.getMethod("getStats", new Class[0]);
                this.innerProcessingRunner = innerProcessingRunner;
            }
            catch (NoSuchMethodException nsme) {
                throw new RuntimeException(nsme);
            }
        }

        public List<String> getKeys() {
            return KEYS;
        }

        @Nullable
        public Map<String, Number> getTotalMetrics() {
            try {
                Map statsMap = (Map)this.getStatsMethod.invoke(this.innerProcessingRunner, new Object[0]);
                if (statsMap == null) {
                    return null;
                }
                long curProcessed = (Long)statsMap.get("rowsProcessed");
                long curProcessedWithErrors = (Long)statsMap.get("rowsProcessedWithErrors");
                long curThrownAway = (Long)statsMap.get("rowsThrownAway");
                long curUnparseable = (Long)statsMap.get("rowsUnparseable");
                return ImmutableMap.of((Object)"rowsProcessed", (Object)curProcessed, (Object)"rowsProcessedWithErrors", (Object)curProcessedWithErrors, (Object)"rowsThrownAway", (Object)curThrownAway, (Object)"rowsUnparseable", (Object)curUnparseable);
            }
            catch (Exception e) {
                log.error((Throwable)e, "Got exception from getTotalMetrics()", new Object[0]);
                return null;
            }
        }
    }

    public static class HadoopIndexerGeneratorCleanupRunner {
        TypeReference<List<DataSegmentAndIndexZipFilePath>> LIST_DATA_SEGMENT_AND_INDEX_ZIP_FILE_PATH = new TypeReference<List<DataSegmentAndIndexZipFilePath>>(){};

        public void runTask(String[] args) throws Exception {
            boolean indexGeneratorJobSucceeded;
            HadoopIngestionSpec indexerSchema;
            if (args.length != 2) {
                log.warn("HadoopIndexerGeneratorCleanupRunner called with improper number of arguments", new Object[0]);
            }
            String indexGeneratorJobSucceededStr = args[0];
            String hadoopIngestionSpecStr = args[1];
            try {
                indexerSchema = (HadoopIngestionSpec)((Object)HadoopDruidIndexerConfig.JSON_MAPPER.readValue(hadoopIngestionSpecStr, HadoopIngestionSpec.class));
                indexGeneratorJobSucceeded = BooleanUtils.toBoolean((String)indexGeneratorJobSucceededStr);
            }
            catch (Exception e) {
                log.warn((Throwable)e, "HadoopIndexerGeneratorCleanupRunner: Error occurred while trying to read input parameters into data objects", new Object[0]);
                throw e;
            }
            JobHelper.maybeDeleteIntermediatePath(indexGeneratorJobSucceeded, indexerSchema);
        }
    }

    public static class HadoopRenameSegmentIndexFilesRunner {
        TypeReference<List<DataSegmentAndIndexZipFilePath>> LIST_DATA_SEGMENT_AND_INDEX_ZIP_FILE_PATH = new TypeReference<List<DataSegmentAndIndexZipFilePath>>(){};

        public void runTask(String[] args) throws Exception {
            List dataSegmentAndIndexZipFilePaths;
            HadoopIngestionSpec indexerSchema;
            if (args.length != 2) {
                log.warn("HadoopRenameSegmentIndexFilesRunner called with improper number of arguments", new Object[0]);
            }
            String hadoopIngestionSpecStr = args[0];
            String dataSegmentAndIndexZipFilePathListStr = args[1];
            try {
                indexerSchema = (HadoopIngestionSpec)((Object)HadoopDruidIndexerConfig.JSON_MAPPER.readValue(hadoopIngestionSpecStr, HadoopIngestionSpec.class));
                dataSegmentAndIndexZipFilePaths = (List)HadoopDruidIndexerConfig.JSON_MAPPER.readValue(dataSegmentAndIndexZipFilePathListStr, this.LIST_DATA_SEGMENT_AND_INDEX_ZIP_FILE_PATH);
            }
            catch (Exception e) {
                log.warn((Throwable)e, "HadoopRenameSegmentIndexFilesRunner: Error occurred while trying to read input parameters into data objects", new Object[0]);
                throw e;
            }
            JobHelper.renameIndexFilesForSegments(indexerSchema, dataSegmentAndIndexZipFilePaths);
        }
    }

    public static class HadoopKillMRJobIdProcessingRunner {
        public String[] runTask(String[] args) throws Exception {
            File hadoopJobIdFile = new File(args[0]);
            String jobId = null;
            try {
                if (hadoopJobIdFile.exists()) {
                    jobId = (String)HadoopDruidIndexerConfig.JSON_MAPPER.readValue(hadoopJobIdFile, String.class);
                }
            }
            catch (Exception e) {
                log.warn((Throwable)e, "exeption while reading hadoop job id from: [%s]", new Object[]{hadoopJobIdFile});
            }
            if (jobId != null) {
                JobHelper.authenticate();
                int res = ToolRunner.run((Tool)new JobClient(), (String[])new String[]{"-kill", jobId});
                return new String[]{jobId, res == 0 ? "Success" : "Fail"};
            }
            return new String[]{jobId, "Fail"};
        }
    }

    public static class HadoopIndexGeneratorInnerProcessingRunner {
        private HadoopDruidIndexerJob job;

        public String runTask(String[] args) throws Exception {
            String schema = args[0];
            String version = args[1];
            String hadoopJobIdFile = args[2];
            HadoopIngestionSpec theSchema = (HadoopIngestionSpec)((Object)HadoopDruidIndexerConfig.JSON_MAPPER.readValue(schema, HadoopIngestionSpec.class));
            HadoopDruidIndexerConfig config = HadoopDruidIndexerConfig.fromSpec(theSchema.withTuningConfig(theSchema.getTuningConfig().withVersion(version)));
            SegmentMetadataPublisher maybeHandler = config.isUpdaterJobSpecSet() ? new SegmentMetadataPublisher((IndexerMetadataStorageCoordinator)HadoopTask.INJECTOR.getInstance(IndexerMetadataStorageCoordinator.class)) : null;
            this.job = new HadoopDruidIndexerJob(config, maybeHandler);
            this.job.setHadoopJobIdFile(hadoopJobIdFile);
            log.info("Starting a hadoop index generator job...", new Object[0]);
            try {
                if (this.job.run()) {
                    return HadoopDruidIndexerConfig.JSON_MAPPER.writeValueAsString((Object)new HadoopIndexGeneratorInnerProcessingStatus(this.job.getPublishedSegmentAndIndexZipFilePaths(), this.job.getStats(), null));
                }
                return HadoopDruidIndexerConfig.JSON_MAPPER.writeValueAsString((Object)new HadoopIndexGeneratorInnerProcessingStatus(null, this.job.getStats(), this.job.getErrorMessage()));
            }
            catch (Exception e) {
                log.error((Throwable)e, "Encountered exception in HadoopIndexGeneratorInnerProcessing.", new Object[0]);
                return HadoopDruidIndexerConfig.JSON_MAPPER.writeValueAsString((Object)new HadoopIndexGeneratorInnerProcessingStatus(null, this.job.getStats(), e.getMessage()));
            }
        }

        public Map<String, Object> getStats() {
            if (this.job == null) {
                return null;
            }
            return this.job.getStats();
        }
    }

    public static class HadoopDetermineConfigInnerProcessingRunner {
        private HadoopDruidDetermineConfigurationJob job;

        public String runTask(String[] args) throws Exception {
            String schema = args[0];
            String workingPath = args[1];
            String segmentOutputPath = args[2];
            String hadoopJobIdFile = args[3];
            HadoopIngestionSpec theSchema = (HadoopIngestionSpec)((Object)HadoopDruidIndexerConfig.JSON_MAPPER.readValue(schema, HadoopIngestionSpec.class));
            HadoopDruidIndexerConfig config = HadoopDruidIndexerConfig.fromSpec(theSchema.withIOConfig(theSchema.getIOConfig().withSegmentOutputPath(segmentOutputPath)).withTuningConfig(theSchema.getTuningConfig().withWorkingPath(workingPath)));
            this.job = new HadoopDruidDetermineConfigurationJob(config);
            this.job.setHadoopJobIdFile(hadoopJobIdFile);
            log.info("Starting a hadoop determine configuration job...", new Object[0]);
            if (this.job.run()) {
                return HadoopDruidIndexerConfig.JSON_MAPPER.writeValueAsString((Object)new HadoopDetermineConfigInnerProcessingStatus(config.getSchema(), this.job.getStats(), null));
            }
            return HadoopDruidIndexerConfig.JSON_MAPPER.writeValueAsString((Object)new HadoopDetermineConfigInnerProcessingStatus(null, this.job.getStats(), this.job.getErrorMessage()));
        }

        public Map<String, Object> getStats() {
            if (this.job == null) {
                return null;
            }
            return this.job.getStats();
        }
    }
}

