/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.ElasticGpus;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.transform.ElasticGpuHealthStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class ElasticGpusStaxUnmarshaller
implements Unmarshaller<ElasticGpus, StaxUnmarshallerContext> {
    private static ElasticGpusStaxUnmarshaller instance;

    public ElasticGpus unmarshall(StaxUnmarshallerContext context) throws Exception {
        ElasticGpus elasticGpus = new ElasticGpus();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return elasticGpus;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("elasticGpuId", targetDepth)) {
                    elasticGpus.setElasticGpuId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("availabilityZone", targetDepth)) {
                    elasticGpus.setAvailabilityZone(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("elasticGpuType", targetDepth)) {
                    elasticGpus.setElasticGpuType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("elasticGpuHealth", targetDepth)) {
                    elasticGpus.setElasticGpuHealth(ElasticGpuHealthStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("elasticGpuState", targetDepth)) {
                    elasticGpus.setElasticGpuState(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instanceId", targetDepth)) {
                    elasticGpus.setInstanceId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    elasticGpus.withTags(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("tagSet/item", targetDepth)) continue;
                elasticGpus.withTags(TagStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return elasticGpus;
    }

    public static ElasticGpusStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ElasticGpusStaxUnmarshaller();
        }
        return instance;
    }
}

