/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.transform.AssociateNatGatewayAddressRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AssociateNatGatewayAddressRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<AssociateNatGatewayAddressRequest> {
    private String natGatewayId;
    private SdkInternalList<String> allocationIds;
    private SdkInternalList<String> privateIpAddresses;

    public void setNatGatewayId(String natGatewayId) {
        this.natGatewayId = natGatewayId;
    }

    public String getNatGatewayId() {
        return this.natGatewayId;
    }

    public AssociateNatGatewayAddressRequest withNatGatewayId(String natGatewayId) {
        this.setNatGatewayId(natGatewayId);
        return this;
    }

    public List<String> getAllocationIds() {
        if (this.allocationIds == null) {
            this.allocationIds = new SdkInternalList();
        }
        return this.allocationIds;
    }

    public void setAllocationIds(Collection<String> allocationIds) {
        if (allocationIds == null) {
            this.allocationIds = null;
            return;
        }
        this.allocationIds = new SdkInternalList(allocationIds);
    }

    public AssociateNatGatewayAddressRequest withAllocationIds(String ... allocationIds) {
        if (this.allocationIds == null) {
            this.setAllocationIds((Collection<String>)new SdkInternalList(allocationIds.length));
        }
        for (String ele : allocationIds) {
            this.allocationIds.add((Object)ele);
        }
        return this;
    }

    public AssociateNatGatewayAddressRequest withAllocationIds(Collection<String> allocationIds) {
        this.setAllocationIds(allocationIds);
        return this;
    }

    public List<String> getPrivateIpAddresses() {
        if (this.privateIpAddresses == null) {
            this.privateIpAddresses = new SdkInternalList();
        }
        return this.privateIpAddresses;
    }

    public void setPrivateIpAddresses(Collection<String> privateIpAddresses) {
        if (privateIpAddresses == null) {
            this.privateIpAddresses = null;
            return;
        }
        this.privateIpAddresses = new SdkInternalList(privateIpAddresses);
    }

    public AssociateNatGatewayAddressRequest withPrivateIpAddresses(String ... privateIpAddresses) {
        if (this.privateIpAddresses == null) {
            this.setPrivateIpAddresses((Collection<String>)new SdkInternalList(privateIpAddresses.length));
        }
        for (String ele : privateIpAddresses) {
            this.privateIpAddresses.add((Object)ele);
        }
        return this;
    }

    public AssociateNatGatewayAddressRequest withPrivateIpAddresses(Collection<String> privateIpAddresses) {
        this.setPrivateIpAddresses(privateIpAddresses);
        return this;
    }

    @Override
    public Request<AssociateNatGatewayAddressRequest> getDryRunRequest() {
        Request<AssociateNatGatewayAddressRequest> request = new AssociateNatGatewayAddressRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNatGatewayId() != null) {
            sb.append("NatGatewayId: ").append(this.getNatGatewayId()).append(",");
        }
        if (this.getAllocationIds() != null) {
            sb.append("AllocationIds: ").append(this.getAllocationIds()).append(",");
        }
        if (this.getPrivateIpAddresses() != null) {
            sb.append("PrivateIpAddresses: ").append(this.getPrivateIpAddresses());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateNatGatewayAddressRequest)) {
            return false;
        }
        AssociateNatGatewayAddressRequest other = (AssociateNatGatewayAddressRequest)obj;
        if (other.getNatGatewayId() == null ^ this.getNatGatewayId() == null) {
            return false;
        }
        if (other.getNatGatewayId() != null && !other.getNatGatewayId().equals(this.getNatGatewayId())) {
            return false;
        }
        if (other.getAllocationIds() == null ^ this.getAllocationIds() == null) {
            return false;
        }
        if (other.getAllocationIds() != null && !other.getAllocationIds().equals(this.getAllocationIds())) {
            return false;
        }
        if (other.getPrivateIpAddresses() == null ^ this.getPrivateIpAddresses() == null) {
            return false;
        }
        return other.getPrivateIpAddresses() == null || other.getPrivateIpAddresses().equals(this.getPrivateIpAddresses());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNatGatewayId() == null ? 0 : this.getNatGatewayId().hashCode());
        hashCode = 31 * hashCode + (this.getAllocationIds() == null ? 0 : this.getAllocationIds().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddresses() == null ? 0 : this.getPrivateIpAddresses().hashCode());
        return hashCode;
    }

    public AssociateNatGatewayAddressRequest clone() {
        return (AssociateNatGatewayAddressRequest)super.clone();
    }
}

