/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.jexl3.JexlFeatures;

public final class Source
implements Comparable<Source> {
    private final int hashCode;
    private final JexlFeatures features;
    private final Map<String, Integer> symbols;
    private final String str;

    Source(JexlFeatures theFeatures, Map<String, Integer> theSymbols, String theStr) {
        this.features = theFeatures;
        this.symbols = theSymbols == null ? Collections.emptyMap() : theSymbols;
        this.str = theStr;
        this.hashCode = Objects.hash(this.features, this.symbols, this.str);
    }

    @Override
    public int compareTo(Source s) {
        int cmp = this.str.compareTo(s.str);
        if (cmp == 0 && (cmp = Integer.compare(this.features.hashCode(), s.features.hashCode())) == 0 && (cmp = Integer.compare(this.symbols.hashCode(), s.symbols.hashCode())) == 0) {
            if (Objects.equals(this.features, s.features)) {
                if (Objects.equals(this.symbols, s.symbols)) {
                    return 0;
                }
                return -1;
            }
            return 1;
        }
        return cmp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Source other = (Source)obj;
        if (!Objects.equals(this.features, other.features)) {
            return false;
        }
        if (!Objects.equals(this.symbols, other.symbols)) {
            return false;
        }
        return Objects.equals(this.str, other.str);
    }

    public JexlFeatures getFeatures() {
        return this.features;
    }

    public int hashCode() {
        return this.hashCode;
    }

    int length() {
        return this.str.length();
    }

    public String toString() {
        return this.str;
    }
}

