/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.shaded.org.roaringbitmap.art;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.celeborn.shaded.org.roaringbitmap.art.Node;
import org.apache.celeborn.shaded.org.roaringbitmap.art.NodeType;
import org.apache.celeborn.shaded.org.roaringbitmap.art.SearchResult;
import org.apache.celeborn.shaded.org.roaringbitmap.longlong.LongUtils;

public class LeafNode
extends Node {
    private long key;
    long containerIdx;
    public static final int LEAF_NODE_KEY_LENGTH_IN_BYTES = 6;

    public LeafNode(byte[] key, long containerIdx) {
        super(NodeType.LEAF_NODE, 0);
        byte[] bytes = new byte[8];
        System.arraycopy(key, 0, bytes, 0, 6);
        this.key = LongUtils.fromBDBytes(bytes);
        this.containerIdx = containerIdx;
    }

    public LeafNode(long key, long containerIdx) {
        super(NodeType.LEAF_NODE, 0);
        this.key = key;
        this.containerIdx = containerIdx;
    }

    @Override
    public void serializeNodeBody(DataOutput dataOutput) throws IOException {
        byte[] keyBytes = LongUtils.highPart(this.key);
        dataOutput.write(keyBytes);
        dataOutput.writeLong(Long.reverseBytes(this.containerIdx));
    }

    @Override
    public void serializeNodeBody(ByteBuffer byteBuffer) throws IOException {
        byte[] keyBytes = LongUtils.highPart(this.key);
        byteBuffer.put(keyBytes);
        byteBuffer.putLong(this.containerIdx);
    }

    @Override
    public void deserializeNodeBody(DataInput dataInput) throws IOException {
        byte[] longBytes = new byte[8];
        dataInput.readFully(longBytes, 0, 6);
        this.key = LongUtils.fromBDBytes(longBytes);
        this.containerIdx = Long.reverseBytes(dataInput.readLong());
    }

    @Override
    public void deserializeNodeBody(ByteBuffer byteBuffer) throws IOException {
        byte[] bytes = new byte[8];
        byteBuffer.get(bytes, 0, 6);
        this.key = LongUtils.fromBDBytes(bytes);
        this.containerIdx = byteBuffer.getLong();
    }

    @Override
    public int serializeNodeBodySizeInBytes() {
        return 14;
    }

    @Override
    public int getChildPos(byte k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchResult getNearestChildPos(byte key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte getChildKey(int pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node getChild(int pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceNode(int pos, Node freshOne) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMinPos() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNextLargerPos(int pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxPos() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNextSmallerPos(int pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node remove(int pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceChildren(Node[] children) {
        throw new UnsupportedOperationException();
    }

    public long getContainerIdx() {
        return this.containerIdx;
    }

    public byte[] getKeyBytes() {
        return LongUtils.highPart(this.key);
    }

    public long getKey() {
        return this.key >>> 16;
    }
}

