/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.celeborn.common.CelebornCRC32;

public class CommitMetadata {
    private final AtomicLong bytes;
    private final CelebornCRC32 crc;

    public CommitMetadata() {
        this.bytes = new AtomicLong();
        this.crc = new CelebornCRC32();
    }

    public CommitMetadata(int checksum, long numBytes) {
        this.bytes = new AtomicLong(numBytes);
        this.crc = new CelebornCRC32(checksum);
    }

    public void addDataWithOffsetAndLength(byte[] rawDataBuf, int offset, int length) {
        this.bytes.addAndGet(length);
        this.crc.addData(rawDataBuf, offset, length);
    }

    public void addCommitData(CommitMetadata commitMetadata) {
        this.addCommitData(commitMetadata.getChecksum(), commitMetadata.getBytes());
    }

    public void addCommitData(int checksum, long numBytes) {
        this.bytes.addAndGet(numBytes);
        this.crc.addChecksum(checksum);
    }

    public int getChecksum() {
        return this.crc.get();
    }

    public long getBytes() {
        return this.bytes.get();
    }

    public static boolean checkCommitMetadata(CommitMetadata expected, CommitMetadata actual) {
        boolean bytesMatch = expected.getBytes() == actual.getBytes();
        boolean checksumsMatch = expected.getChecksum() == actual.getChecksum();
        return bytesMatch && checksumsMatch;
    }

    public String toString() {
        return "CommitMetadata{bytes=" + this.bytes.get() + ", crc=" + this.crc + '}';
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitMetadata that = (CommitMetadata)o;
        return this.bytes.get() == that.bytes.get() && Objects.equals(this.crc, that.crc);
    }

    public int hashCode() {
        return Objects.hash(this.bytes, this.crc);
    }
}

