/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.event.DomainEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.DomainDisplayEvent;
import org.apache.cayenne.modeler.event.DomainDisplayListener;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.pref.RenamedPreferences;
import org.apache.cayenne.swing.components.JCayenneCheckBox;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationException;

public class DataDomainView
extends JPanel
implements DomainDisplayListener {
    protected ProjectController projectController;
    protected TextAdapter name;
    protected JCheckBox objectValidation;
    protected JCheckBox sharedCache;

    public DataDomainView(ProjectController projectController) {
        this.projectController = projectController;
        this.initView();
        this.initController();
    }

    protected void initView() {
        this.name = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                DataDomainView.this.setDomainName(text);
            }
        };
        this.objectValidation = new JCayenneCheckBox();
        this.sharedCache = new JCayenneCheckBox();
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("right:pref, 3dlu, fill:50dlu, 3dlu, fill:47dlu, 3dlu, fill:100", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.addSeparator("DataDomain Configuration", cc.xywh(1, 1, 7, 1));
        builder.addLabel("DataDomain Name:", cc.xy(1, 3));
        builder.add((Component)this.name.getComponent(), cc.xywh(3, 3, 5, 1));
        builder.addLabel("Object Validation:", cc.xy(1, 5));
        builder.add((Component)this.objectValidation, cc.xy(3, 5));
        builder.addLabel("Use Shared Cache:", cc.xy(1, 7));
        builder.add((Component)this.sharedCache, cc.xy(3, 7));
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "Center");
    }

    protected void initController() {
        this.projectController.addDomainDisplayListener(this);
        this.objectValidation.addItemListener(e -> {
            String value = this.objectValidation.isSelected() ? "true" : "false";
            this.setDomainProperty("cayenne.DataDomain.validatingObjectsOnCommit", value, Boolean.toString(true));
        });
        this.sharedCache.addItemListener(e -> {
            String value = this.sharedCache.isSelected() ? "true" : "false";
            this.setDomainProperty("cayenne.DataDomain.sharedCache", value, Boolean.toString(true));
        });
    }

    protected void setDomainProperty(String property, String value, String defaultValue) {
        Map<String, String> properties;
        String oldValue;
        DataChannelDescriptor domain = (DataChannelDescriptor)this.projectController.getProject().getRootNode();
        if (domain == null) {
            return;
        }
        if ("".equals(value)) {
            value = null;
        }
        if (value != null && value.equals(defaultValue)) {
            value = null;
        }
        if (!Util.nullSafeEquals(value, oldValue = (properties = domain.getProperties()).get(property))) {
            properties.put(property, value);
            DomainEvent e = new DomainEvent((Object)this, domain);
            this.projectController.fireDomainEvent(e);
        }
    }

    public String getDomainProperty(String property, String defaultValue) {
        DataChannelDescriptor domain = (DataChannelDescriptor)this.projectController.getProject().getRootNode();
        if (domain == null) {
            return null;
        }
        String value = domain.getProperties().get(property);
        return value != null ? value : defaultValue;
    }

    public boolean getDomainBooleanProperty(String property, String defaultValue) {
        return "true".equalsIgnoreCase(this.getDomainProperty(property, defaultValue));
    }

    @Override
    public void currentDomainChanged(DomainDisplayEvent e) {
        DataChannelDescriptor domain = e.getDomain();
        if (null == domain) {
            return;
        }
        this.name.setText(domain.getName());
        this.objectValidation.setSelected(this.getDomainBooleanProperty("cayenne.DataDomain.validatingObjectsOnCommit", Boolean.toString(true)));
        this.sharedCache.setSelected(this.getDomainBooleanProperty("cayenne.DataDomain.sharedCache", Boolean.toString(true)));
    }

    void setDomainName(String newName) {
        DataChannelDescriptor dataChannelDescriptor = (DataChannelDescriptor)Application.getInstance().getProject().getRootNode();
        if (Util.nullSafeEquals(dataChannelDescriptor.getName(), newName)) {
            return;
        }
        if (newName == null || newName.trim().length() == 0) {
            throw new ValidationException("Enter name for DataDomain", new Object[0]);
        }
        Preferences prefs = this.projectController.getPreferenceForDataDomain();
        DomainEvent e = new DomainEvent((Object)this, dataChannelDescriptor, dataChannelDescriptor.getName());
        dataChannelDescriptor.setName(newName);
        RenamedPreferences.copyPreferences(newName, prefs);
        this.projectController.fireDomainEvent(e);
    }
}

