/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import java.util.Objects;

public class ReplicationFactor {
    private final int allReplicas;
    private final int fullReplicas;
    private final int transientReplicas;

    public ReplicationFactor(int allReplicas, int transientReplicas) {
        this.allReplicas = allReplicas;
        this.transientReplicas = transientReplicas;
        this.fullReplicas = allReplicas - transientReplicas;
    }

    public ReplicationFactor(int allReplicas) {
        this(allReplicas, 0);
    }

    public int fullReplicas() {
        return this.fullReplicas;
    }

    public int transientReplicas() {
        return this.transientReplicas;
    }

    public boolean hasTransientReplicas() {
        return this.allReplicas != this.fullReplicas;
    }

    public static ReplicationFactor fromString(String s) {
        if (s.contains("/")) {
            int slash = s.indexOf(47);
            String allPart = s.substring(0, slash);
            String transientPart = s.substring(slash + 1);
            return new ReplicationFactor(Integer.parseInt(allPart), Integer.parseInt(transientPart));
        }
        return new ReplicationFactor(Integer.parseInt(s), 0);
    }

    public String toString() {
        return this.allReplicas + (this.hasTransientReplicas() ? "/" + this.transientReplicas() : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReplicationFactor)) {
            return false;
        }
        ReplicationFactor that = (ReplicationFactor)o;
        return this.allReplicas == that.allReplicas && this.fullReplicas == that.fullReplicas;
    }

    public int hashCode() {
        return Objects.hash(this.allReplicas, this.fullReplicas);
    }
}

