/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.ObjectOutput;
import java.util.List;
import java.util.Map;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

class WireObjectOutput
implements ObjectOutput {
    private final WireOut wire;

    WireObjectOutput(WireOut wire) {
        this.wire = wire;
    }

    @Override
    public void writeObject(Object obj) {
        @NotNull ValueOut valueOut = this.wire.getValueOut();
        if (obj instanceof Map) {
            valueOut.typePrefix(Map.class);
        } else if (obj instanceof List) {
            valueOut.typePrefix(List.class);
        }
        valueOut.object(obj);
    }

    @Override
    public void write(int b) {
        this.wire.getValueOut().uint8(b);
    }

    @Override
    public void write(byte[] b) {
        this.wire.getValueOut().bytes(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off == 0 && len == b.length) {
            this.write(b);
        } else {
            this.wire.getValueOut().bytes((BytesStore)Bytes.wrapForRead((byte[])b).readPositionRemaining((long)off, (long)len));
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public void writeBoolean(boolean v) {
        this.wire.getValueOut().bool(v);
    }

    @Override
    public void writeByte(int v) {
        this.wire.getValueOut().int8(v);
    }

    @Override
    public void writeShort(int v) {
        this.wire.getValueOut().int16(v);
    }

    @Override
    public void writeChar(int v) {
        this.wire.getValueOut().uint16(v);
    }

    @Override
    public void writeInt(int v) {
        this.wire.getValueOut().uint16(v);
    }

    @Override
    public void writeLong(long v) {
        this.wire.getValueOut().int64(v);
    }

    @Override
    public void writeFloat(float v) {
        this.wire.getValueOut().float32(v);
    }

    @Override
    public void writeDouble(double v) {
        this.wire.getValueOut().float64(v);
    }

    @Override
    public void writeBytes(@NotNull String s) {
        this.wire.getValueOut().text(s);
    }

    @Override
    public void writeChars(@NotNull String s) {
        this.wire.getValueOut().text(s);
    }

    @Override
    public void writeUTF(@NotNull String s) {
        this.wire.getValueOut().text(s);
    }
}

