/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.cassandra.cache.AutoSavingCache;
import org.apache.cassandra.cache.CacheProvider;
import org.apache.cassandra.cache.CaffeineCache;
import org.apache.cassandra.cache.CounterCacheKey;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.cache.IRowCacheEntry;
import org.apache.cassandra.cache.KeyCacheKey;
import org.apache.cassandra.cache.RowCacheKey;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ClockAndCount;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.partitions.CachedBTreePartition;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.AbstractRowIndexEntry;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableId;
import org.apache.cassandra.io.sstable.SSTableIdFactory;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.keycache.KeyCacheSupport;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.CacheServiceMBean;
import org.apache.cassandra.utils.ByteArrayUtil;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MBeanWrapper;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.concurrent.Future;
import org.apache.cassandra.utils.concurrent.ImmediateFuture;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheService
implements CacheServiceMBean {
    private static final Logger logger = LoggerFactory.getLogger(CacheService.class);
    public static final String MBEAN_NAME = "org.apache.cassandra.db:type=Caches";
    public static final CacheService instance = new CacheService();
    public final AutoSavingCache<KeyCacheKey, AbstractRowIndexEntry> keyCache;
    public final AutoSavingCache<RowCacheKey, IRowCacheEntry> rowCache;
    public final AutoSavingCache<CounterCacheKey, ClockAndCount> counterCache;

    private CacheService() {
        MBeanWrapper.instance.registerMBean((Object)this, MBEAN_NAME);
        this.keyCache = this.initKeyCache();
        this.rowCache = this.initRowCache();
        this.counterCache = this.initCounterCache();
    }

    private AutoSavingCache<KeyCacheKey, AbstractRowIndexEntry> initKeyCache() {
        logger.info("Initializing key cache with capacity of {} MiBs.", (Object)DatabaseDescriptor.getKeyCacheSizeInMiB());
        long keyCacheInMemoryCapacity = DatabaseDescriptor.getKeyCacheSizeInMiB() * 1024L * 1024L;
        CaffeineCache kc = CaffeineCache.create(keyCacheInMemoryCapacity);
        AutoSavingCache<KeyCacheKey, AbstractRowIndexEntry> keyCache = new AutoSavingCache<KeyCacheKey, AbstractRowIndexEntry>(kc, CacheType.KEY_CACHE, new KeyCacheSerializer());
        int keyCacheKeysToSave = DatabaseDescriptor.getKeyCacheKeysToSave();
        keyCache.scheduleSaving(DatabaseDescriptor.getKeyCacheSavePeriod(), keyCacheKeysToSave);
        return keyCache;
    }

    private AutoSavingCache<RowCacheKey, IRowCacheEntry> initRowCache() {
        CacheProvider cacheProvider;
        logger.info("Initializing row cache with capacity of {} MiBs", (Object)DatabaseDescriptor.getRowCacheSizeInMiB());
        String cacheProviderClassName = DatabaseDescriptor.getRowCacheSizeInMiB() > 0L ? DatabaseDescriptor.getRowCacheClassName() : "org.apache.cassandra.cache.NopCacheProvider";
        try {
            Class<?> cacheProviderClass = Class.forName(cacheProviderClassName);
            cacheProvider = (CacheProvider)cacheProviderClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot find configured row cache provider class " + DatabaseDescriptor.getRowCacheClassName());
        }
        ICache rc = cacheProvider.create();
        AutoSavingCache<RowCacheKey, IRowCacheEntry> rowCache = new AutoSavingCache<RowCacheKey, IRowCacheEntry>(rc, CacheType.ROW_CACHE, new RowCacheSerializer());
        int rowCacheKeysToSave = DatabaseDescriptor.getRowCacheKeysToSave();
        rowCache.scheduleSaving(DatabaseDescriptor.getRowCacheSavePeriod(), rowCacheKeysToSave);
        return rowCache;
    }

    private AutoSavingCache<CounterCacheKey, ClockAndCount> initCounterCache() {
        logger.info("Initializing counter cache with capacity of {} MiBs", (Object)DatabaseDescriptor.getCounterCacheSizeInMiB());
        long capacity = DatabaseDescriptor.getCounterCacheSizeInMiB() * 1024L * 1024L;
        AutoSavingCache<CounterCacheKey, ClockAndCount> cache = new AutoSavingCache<CounterCacheKey, ClockAndCount>(CaffeineCache.create(capacity), CacheType.COUNTER_CACHE, new CounterCacheSerializer());
        int keysToSave = DatabaseDescriptor.getCounterCacheKeysToSave();
        logger.info("Scheduling counter cache save to every {} seconds (going to save {} keys).", (Object)DatabaseDescriptor.getCounterCacheSavePeriod(), keysToSave == Integer.MAX_VALUE ? "all" : Integer.valueOf(keysToSave));
        cache.scheduleSaving(DatabaseDescriptor.getCounterCacheSavePeriod(), keysToSave);
        return cache;
    }

    @Override
    public int getRowCacheSavePeriodInSeconds() {
        return DatabaseDescriptor.getRowCacheSavePeriod();
    }

    @Override
    public void setRowCacheSavePeriodInSeconds(int seconds) {
        if (seconds < 0) {
            throw new RuntimeException("RowCacheSavePeriodInSeconds must be non-negative.");
        }
        DatabaseDescriptor.setRowCacheSavePeriod(seconds);
        this.rowCache.scheduleSaving(seconds, DatabaseDescriptor.getRowCacheKeysToSave());
    }

    @Override
    public int getKeyCacheSavePeriodInSeconds() {
        return DatabaseDescriptor.getKeyCacheSavePeriod();
    }

    @Override
    public void setKeyCacheSavePeriodInSeconds(int seconds) {
        if (seconds < 0) {
            throw new RuntimeException("KeyCacheSavePeriodInSeconds must be non-negative.");
        }
        DatabaseDescriptor.setKeyCacheSavePeriod(seconds);
        this.keyCache.scheduleSaving(seconds, DatabaseDescriptor.getKeyCacheKeysToSave());
    }

    @Override
    public int getCounterCacheSavePeriodInSeconds() {
        return DatabaseDescriptor.getCounterCacheSavePeriod();
    }

    @Override
    public void setCounterCacheSavePeriodInSeconds(int seconds) {
        if (seconds < 0) {
            throw new RuntimeException("CounterCacheSavePeriodInSeconds must be non-negative.");
        }
        DatabaseDescriptor.setCounterCacheSavePeriod(seconds);
        this.counterCache.scheduleSaving(seconds, DatabaseDescriptor.getCounterCacheKeysToSave());
    }

    @Override
    public int getRowCacheKeysToSave() {
        return DatabaseDescriptor.getRowCacheKeysToSave();
    }

    @Override
    public void setRowCacheKeysToSave(int count) {
        if (count < 0) {
            throw new RuntimeException("RowCacheKeysToSave must be non-negative.");
        }
        DatabaseDescriptor.setRowCacheKeysToSave(count);
        this.rowCache.scheduleSaving(this.getRowCacheSavePeriodInSeconds(), count);
    }

    @Override
    public int getKeyCacheKeysToSave() {
        return DatabaseDescriptor.getKeyCacheKeysToSave();
    }

    @Override
    public void setKeyCacheKeysToSave(int count) {
        if (count < 0) {
            throw new RuntimeException("KeyCacheKeysToSave must be non-negative.");
        }
        DatabaseDescriptor.setKeyCacheKeysToSave(count);
        this.keyCache.scheduleSaving(this.getKeyCacheSavePeriodInSeconds(), count);
    }

    @Override
    public int getCounterCacheKeysToSave() {
        return DatabaseDescriptor.getCounterCacheKeysToSave();
    }

    @Override
    public void setCounterCacheKeysToSave(int count) {
        if (count < 0) {
            throw new RuntimeException("CounterCacheKeysToSave must be non-negative.");
        }
        DatabaseDescriptor.setCounterCacheKeysToSave(count);
        this.counterCache.scheduleSaving(this.getCounterCacheSavePeriodInSeconds(), count);
    }

    @Override
    public void invalidateKeyCache() {
        this.keyCache.clear();
    }

    public void invalidateKeyCacheForCf(TableMetadata tableMetadata) {
        Iterator keyCacheIterator = this.keyCache.keyIterator();
        while (keyCacheIterator.hasNext()) {
            KeyCacheKey key = (KeyCacheKey)keyCacheIterator.next();
            if (!key.sameTable(tableMetadata)) continue;
            keyCacheIterator.remove();
        }
    }

    @Override
    public void invalidateRowCache() {
        this.rowCache.clear();
    }

    public void invalidateRowCacheForCf(TableMetadata tableMetadata) {
        Iterator rowCacheIterator = this.rowCache.keyIterator();
        while (rowCacheIterator.hasNext()) {
            RowCacheKey key = (RowCacheKey)rowCacheIterator.next();
            if (!key.sameTable(tableMetadata)) continue;
            rowCacheIterator.remove();
        }
    }

    public void invalidateCounterCacheForCf(TableMetadata tableMetadata) {
        Iterator counterCacheIterator = this.counterCache.keyIterator();
        while (counterCacheIterator.hasNext()) {
            CounterCacheKey key = (CounterCacheKey)counterCacheIterator.next();
            if (!key.sameTable(tableMetadata)) continue;
            counterCacheIterator.remove();
        }
    }

    @Override
    public void invalidateCounterCache() {
        this.counterCache.clear();
    }

    @Override
    public void setRowCacheCapacityInMB(long capacity) {
        if (capacity < 0L) {
            throw new RuntimeException("capacity should not be negative.");
        }
        this.rowCache.setCapacity(capacity * 1024L * 1024L);
    }

    @Override
    public void setKeyCacheCapacityInMB(long capacity) {
        if (capacity < 0L) {
            throw new RuntimeException("capacity should not be negative.");
        }
        this.keyCache.setCapacity(capacity * 1024L * 1024L);
    }

    @Override
    public void setCounterCacheCapacityInMB(long capacity) {
        if (capacity < 0L) {
            throw new RuntimeException("capacity should not be negative.");
        }
        this.counterCache.setCapacity(capacity * 1024L * 1024L);
    }

    @Override
    public void saveCaches() throws ExecutionException, InterruptedException {
        ArrayList futures = new ArrayList(3);
        logger.debug("submitting cache saves");
        futures.add(this.keyCache.submitWrite(DatabaseDescriptor.getKeyCacheKeysToSave()));
        futures.add(this.rowCache.submitWrite(DatabaseDescriptor.getRowCacheKeysToSave()));
        futures.add(this.counterCache.submitWrite(DatabaseDescriptor.getCounterCacheKeysToSave()));
        FBUtilities.waitOnFutures(futures);
        logger.debug("cache saves completed");
    }

    public static class KeyCacheSerializer
    extends AutoSavingCache.CacheSerializer<KeyCacheKey, AbstractRowIndexEntry> {
        private final ArrayList<Pair<KeyCacheSupport<?>, SSTableFormat<?, ?>>> readers = new ArrayList();
        private final LinkedHashMap<Descriptor, Pair<Integer, ColumnFamilyStore>> readerOrdinals = new LinkedHashMap();

        @Override
        public void serializeMetadata(DataOutputPlus out) throws IOException {
            super.serializeMetadata(out);
            out.writeUnsignedVInt32(this.readerOrdinals.size());
            for (Map.Entry<Descriptor, Pair<Integer, ColumnFamilyStore>> table : this.readerOrdinals.entrySet()) {
                Descriptor desc = table.getKey();
                ColumnFamilyStore cfs = (ColumnFamilyStore)table.getValue().right;
                super.writeCFS(out, cfs);
                out.writeUTF(desc.version.format.name());
                out.writeUTF(desc.version.toString());
                ByteBufferUtil.writeWithShortLength(desc.id.asBytes(), out);
            }
        }

        @Override
        public void deserializeMetadata(DataInputPlus in) throws IOException {
            super.deserializeMetadata(in);
            HashMap tmpReaders = new HashMap();
            int sstablesNum = in.readUnsignedVInt32();
            this.readers.clear();
            this.readers.ensureCapacity(sstablesNum);
            for (int i = 0; i < sstablesNum; ++i) {
                ColumnFamilyStore cfs = this.readCFS(in);
                String formatName = in.readUTF();
                SSTableFormat format = Objects.requireNonNull((SSTableFormat)DatabaseDescriptor.getSSTableFormats().get((Object)formatName), "Unknown SSTable format: " + formatName);
                String version = in.readUTF();
                SSTableId id = SSTableIdFactory.instance.fromBytes(ByteBufferUtil.readWithShortLength(in));
                SSTableReader reader = null;
                if (cfs != null) {
                    HashMap<ImmutableTriple, SSTableReader> readersMap = (HashMap<ImmutableTriple, SSTableReader>)tmpReaders.get(cfs);
                    if (readersMap == null) {
                        Set<SSTableReader> liveReaders = cfs.getLiveSSTables();
                        readersMap = new HashMap<ImmutableTriple, SSTableReader>(liveReaders.size());
                        for (SSTableReader r : liveReaders) {
                            readersMap.put(ImmutableTriple.of((Object)r.descriptor.id, (Object)r.descriptor.version.toString(), r.descriptor.version.format), r);
                        }
                        tmpReaders.put(cfs, readersMap);
                    }
                    reader = (SSTableReader)readersMap.get(ImmutableTriple.of((Object)id, (Object)version, (Object)format));
                }
                if (reader instanceof KeyCacheSupport) {
                    this.readers.add(Pair.create((KeyCacheSupport)((Object)reader), format));
                    continue;
                }
                this.readers.add(Pair.create(null, format));
            }
        }

        @Override
        public void serialize(KeyCacheKey key, DataOutputPlus out, ColumnFamilyStore cfs) throws IOException {
            AbstractRowIndexEntry entry = (AbstractRowIndexEntry)CacheService.instance.keyCache.getInternal(key);
            if (entry == null) {
                return;
            }
            this.writeSSTable(cfs, key.desc, out);
            out.writeInt(key.key.length);
            out.write(key.key);
            entry.serializeForCache(out);
        }

        @Override
        public Future<Pair<KeyCacheKey, AbstractRowIndexEntry>> deserialize(DataInputPlus input) throws IOException {
            AbstractRowIndexEntry cacheValue;
            Pair<KeyCacheSupport<?>, SSTableFormat<?, ?>> reader = this.readSSTable(input);
            boolean skipEntry = reader.left == null || !((KeyCacheSupport)reader.left).getKeyCache().isEnabled();
            int keyLength = input.readInt();
            if (keyLength > 65535) {
                throw new IOException(String.format("Corrupted key cache. Key length of %d is longer than maximum of %d", keyLength, 65535));
            }
            ByteBuffer key = ByteBufferUtil.read(input, keyLength);
            if (skipEntry) {
                SSTableFormat.KeyCacheValueSerializer serializer = ((SSTableFormat)reader.right).getKeyCacheValueSerializer();
                serializer.skip(input);
                return null;
            }
            long pos = ((RandomAccessReader)input).getPosition();
            try {
                cacheValue = ((KeyCacheSupport)reader.left).deserializeKeyCacheValue(input);
            }
            catch (Error | RuntimeException ex) {
                logger.error("Deserializing key cache entry at {} for {}", (Object)pos, reader.left);
                throw ex;
            }
            KeyCacheKey cacheKey = ((KeyCacheSupport)reader.left).getCacheKey(key);
            return ImmediateFuture.success(Pair.create(cacheKey, cacheValue));
        }

        private void writeSSTable(ColumnFamilyStore cfs, Descriptor desc, DataOutputPlus out) throws IOException {
            this.getOrCreateCFSOrdinal(cfs);
            Pair<Integer, ColumnFamilyStore> existing = this.readerOrdinals.putIfAbsent(desc, Pair.create(this.readerOrdinals.size(), cfs));
            int ordinal = existing == null ? this.readerOrdinals.size() - 1 : (Integer)existing.left;
            out.writeUnsignedVInt32(ordinal);
        }

        private Pair<KeyCacheSupport<?>, SSTableFormat<?, ?>> readSSTable(DataInputPlus input) throws IOException {
            int ordinal = input.readUnsignedVInt32();
            if (ordinal >= this.readers.size()) {
                throw new IOException("Corrupted key cache. Failed to deserialize key of key cache - invalid sstable ordinal " + ordinal);
            }
            return this.readers.get(ordinal);
        }

        @Override
        public void cleanupAfterDeserialize() {
            super.cleanupAfterDeserialize();
            this.readers.clear();
        }

        @Override
        public void cleanupAfterSerialize() {
            super.cleanupAfterSerialize();
            this.readerOrdinals.clear();
        }
    }

    public static class RowCacheSerializer
    extends AutoSavingCache.CacheSerializer<RowCacheKey, IRowCacheEntry> {
        @Override
        public void serialize(RowCacheKey key, DataOutputPlus out, ColumnFamilyStore cfs) throws IOException {
            assert (!cfs.isIndex());
            this.writeCFS(out, cfs);
            ByteArrayUtil.writeWithLength(key.key, out);
        }

        @Override
        public Future<Pair<RowCacheKey, IRowCacheEntry>> deserialize(DataInputPlus in) throws IOException {
            ColumnFamilyStore cfs = this.readCFS(in);
            ByteBuffer buffer = ByteBufferUtil.readWithLength(in);
            if (cfs == null || !cfs.isRowCacheEnabled()) {
                return null;
            }
            int rowsToCache = cfs.metadata().params.caching.rowsPerPartitionToCache();
            assert (!cfs.isIndex());
            return Stage.READ.submit(() -> {
                DecoratedKey key = cfs.decorateKey(buffer);
                long nowInSec = FBUtilities.nowInSeconds();
                SinglePartitionReadCommand cmd = SinglePartitionReadCommand.fullPartitionRead(cfs.metadata(), nowInSec, key);
                try (ReadExecutionController controller = cmd.executionController();){
                    Pair<RowCacheKey, CachedBTreePartition> pair;
                    block12: {
                        UnfilteredRowIterator iter = cmd.queryMemtableAndDisk(cfs, controller);
                        try {
                            CachedBTreePartition toCache = CachedBTreePartition.create(DataLimits.cqlLimits(rowsToCache).filter(iter, nowInSec, true), nowInSec);
                            pair = Pair.create(new RowCacheKey(cfs.metadata(), key), toCache);
                            if (iter == null) break block12;
                        }
                        catch (Throwable throwable) {
                            if (iter != null) {
                                try {
                                    iter.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        iter.close();
                    }
                    return pair;
                }
            });
        }
    }

    public static class CounterCacheSerializer
    extends AutoSavingCache.CacheSerializer<CounterCacheKey, ClockAndCount> {
        @Override
        public void serialize(CounterCacheKey key, DataOutputPlus out, ColumnFamilyStore cfs) throws IOException {
            assert (cfs.metadata().isCounter());
            this.writeCFS(out, cfs);
            key.write(out);
        }

        @Override
        public Future<Pair<CounterCacheKey, ClockAndCount>> deserialize(DataInputPlus in) throws IOException {
            ColumnFamilyStore cfs = this.readCFS(in);
            if (cfs == null) {
                return null;
            }
            CounterCacheKey cacheKey = CounterCacheKey.read(cfs.metadata(), in);
            if (!cfs.metadata().isCounter() || !cfs.isCounterCacheEnabled()) {
                return null;
            }
            return Stage.READ.submit(() -> {
                ByteBuffer value = cacheKey.readCounterValue(cfs);
                return value == null ? null : Pair.create(cacheKey, CounterContext.instance().getLocalClockAndCount(value));
            });
        }
    }

    public static enum CacheType {
        KEY_CACHE("KeyCache"),
        ROW_CACHE("RowCache"),
        COUNTER_CACHE("CounterCache");

        private final String name;

        private CacheType(String typeName) {
            this.name = typeName;
        }

        public String toString() {
            return this.name;
        }
    }
}

