/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.bti;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.sstable.AbstractRowIndexEntry;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.format.DataComponent;
import org.apache.cassandra.io.sstable.format.IndexComponent;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SortedTableWriter;
import org.apache.cassandra.io.sstable.format.bti.BtiFormat;
import org.apache.cassandra.io.sstable.format.bti.BtiFormatPartitionWriter;
import org.apache.cassandra.io.sstable.format.bti.BtiTableReader;
import org.apache.cassandra.io.sstable.format.bti.PartitionIndex;
import org.apache.cassandra.io.sstable.format.bti.PartitionIndexBuilder;
import org.apache.cassandra.io.sstable.format.bti.TrieIndexEntry;
import org.apache.cassandra.io.util.DataPosition;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.MmappedRegionsCache;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public class BtiTableWriter
extends SortedTableWriter<BtiFormatPartitionWriter, IndexWriter> {
    private static final Logger logger = LoggerFactory.getLogger(BtiTableWriter.class);

    public BtiTableWriter(Builder builder, LifecycleNewTracker lifecycleNewTracker, SSTable.Owner owner) {
        super(builder, lifecycleNewTracker, owner);
    }

    @Override
    protected TrieIndexEntry createRowIndexEntry(DecoratedKey key, DeletionTime partitionLevelDeletion, long finishResult) throws IOException {
        TrieIndexEntry entry = TrieIndexEntry.create(((BtiFormatPartitionWriter)this.partitionWriter).getInitialPosition(), finishResult, partitionLevelDeletion, ((BtiFormatPartitionWriter)this.partitionWriter).getRowIndexBlockCount());
        ((IndexWriter)this.indexWriter).append(key, entry);
        return entry;
    }

    private BtiTableReader openInternal(SSTableReader.OpenReason openReason, boolean isFinal, Supplier<PartitionIndex> partitionIndexSupplier) {
        IFilter filter = null;
        FileHandle dataFile = null;
        PartitionIndex partitionIndex = null;
        FileHandle rowIndexFile = null;
        BtiTableReader.Builder builder = (BtiTableReader.Builder)((BtiTableReader.Builder)((BtiTableReader.Builder)this.unbuildTo(new BtiTableReader.Builder(this.descriptor), true).setMaxDataAge(this.maxDataAge)).setSerializationHeader(this.header)).setOpenReason(openReason);
        try {
            builder.setStatsMetadata(this.statsMetadata());
            partitionIndex = partitionIndexSupplier.get();
            rowIndexFile = ((IndexWriter)this.indexWriter).rowIndexFHBuilder.complete();
            dataFile = this.openDataFile(isFinal ? -1L : this.dataWriter.getLastFlushOffset(), builder.getStatsMetadata());
            filter = ((IndexWriter)this.indexWriter).getFilterCopy();
            return (BtiTableReader)((BtiTableReader.Builder)((BtiTableReader.Builder)((BtiTableReader.Builder)((BtiTableReader.Builder)builder.setPartitionIndex(partitionIndex).setFirst(partitionIndex.firstKey())).setLast(partitionIndex.lastKey())).setRowIndexFile(rowIndexFile).setDataFile(dataFile)).setFilter(filter)).build(this.owner().orElse(null), true, true);
        }
        catch (Error | RuntimeException ex) {
            JVMStabilityInspector.inspectThrowable(ex);
            Throwables.closeNonNullAndAddSuppressed(ex, filter, dataFile, rowIndexFile, partitionIndex);
            throw ex;
        }
    }

    @Override
    public void openEarly(Consumer<SSTableReader> callWhenReady) {
        long dataLength = this.dataWriter.position();
        ((IndexWriter)this.indexWriter).buildPartial(dataLength, partitionIndex -> {
            ((IndexWriter)this.indexWriter).rowIndexFHBuilder.withLengthOverride(((IndexWriter)this.indexWriter).rowIndexWriter.getLastFlushOffset());
            BtiTableReader reader = this.openInternal(SSTableReader.OpenReason.EARLY, false, () -> partitionIndex);
            callWhenReady.accept(reader);
        });
    }

    @Override
    public SSTableReader openFinalEarly() {
        ((IndexWriter)this.indexWriter).complete();
        this.dataWriter.sync();
        ((IndexWriter)this.indexWriter).rowIndexWriter.sync();
        return this.openFinal(SSTableReader.OpenReason.EARLY);
    }

    @Override
    protected SSTableReader openFinal(SSTableReader.OpenReason openReason) {
        if (this.maxDataAge < 0L) {
            this.maxDataAge = Clock.Global.currentTimeMillis();
        }
        return this.openInternal(openReason, true, ((IndexWriter)this.indexWriter)::completedPartitionIndex);
    }

    public static class Builder
    extends SortedTableWriter.Builder<BtiFormatPartitionWriter, IndexWriter, BtiTableWriter, Builder> {
        private MmappedRegionsCache mmappedRegionsCache;
        private OperationType operationType;
        private boolean dataWriterOpened;
        private boolean partitionWriterOpened;
        private boolean indexWriterOpened;

        public Builder(Descriptor descriptor) {
            super(descriptor);
        }

        @Override
        public Builder addDefaultComponents(Collection<Index.Group> indexGroups) {
            super.addDefaultComponents((Collection)indexGroups);
            this.addComponents((Collection<Component>)ImmutableSet.of((Object)BtiFormat.Components.PARTITION_INDEX, (Object)BtiFormat.Components.ROW_INDEX));
            return this;
        }

        @Override
        public MmappedRegionsCache getMmappedRegionsCache() {
            return this.ensuringInBuildInternalContext(this.mmappedRegionsCache);
        }

        @Override
        protected SequentialWriter openDataWriter() {
            Preconditions.checkState((!this.dataWriterOpened ? 1 : 0) != 0, (Object)"Data writer has been already opened.");
            return DataComponent.buildWriter(this.descriptor, this.getTableMetadataRef().getLocal(), this.getIOOptions().writerOptions, this.getMetadataCollector(), this.ensuringInBuildInternalContext(this.operationType), this.getIOOptions().flushCompression);
        }

        @Override
        protected IndexWriter openIndexWriter(SequentialWriter dataWriter) {
            Preconditions.checkNotNull((Object)dataWriter);
            Preconditions.checkState((!this.indexWriterOpened ? 1 : 0) != 0, (Object)"Index writer has been already opened.");
            IndexWriter indexWriter = new IndexWriter(this, dataWriter);
            this.indexWriterOpened = true;
            return indexWriter;
        }

        @Override
        protected BtiFormatPartitionWriter openPartitionWriter(SequentialWriter dataWriter, IndexWriter indexWriter) {
            Preconditions.checkNotNull((Object)dataWriter);
            Preconditions.checkNotNull((Object)indexWriter);
            Preconditions.checkState((!this.partitionWriterOpened ? 1 : 0) != 0, (Object)"Partition writer has been already opened.");
            BtiFormatPartitionWriter partitionWriter = new BtiFormatPartitionWriter(this.getSerializationHeader(), this.getTableMetadataRef().getLocal().comparator, dataWriter, indexWriter.rowIndexWriter, this.descriptor.version);
            this.partitionWriterOpened = true;
            return partitionWriter;
        }

        private <T> T ensuringInBuildInternalContext(T value) {
            Preconditions.checkState((value != null ? 1 : 0) != 0, (Object)"The requested resource has not been initialized yet.");
            return value;
        }

        @Override
        protected BtiTableWriter buildInternal(LifecycleNewTracker lifecycleNewTracker, SSTable.Owner owner) {
            try {
                this.mmappedRegionsCache = new MmappedRegionsCache();
                this.operationType = lifecycleNewTracker.opType();
                BtiTableWriter btiTableWriter = new BtiTableWriter(this, lifecycleNewTracker, owner);
                return btiTableWriter;
            }
            catch (Error | RuntimeException ex) {
                Throwables.closeAndAddSuppressed(ex, this.mmappedRegionsCache);
                throw ex;
            }
            finally {
                this.mmappedRegionsCache = null;
                this.partitionWriterOpened = false;
                this.indexWriterOpened = false;
                this.dataWriterOpened = false;
            }
        }
    }

    protected static class IndexWriter
    extends SortedTableWriter.AbstractIndexWriter {
        final SequentialWriter rowIndexWriter;
        private final FileHandle.Builder rowIndexFHBuilder;
        private final SequentialWriter partitionIndexWriter;
        private final FileHandle.Builder partitionIndexFHBuilder;
        private final PartitionIndexBuilder partitionIndex;
        boolean partitionIndexCompleted = false;
        private DataPosition riMark;
        private DataPosition piMark;

        IndexWriter(Builder b, SequentialWriter dataWriter) {
            super(b);
            this.rowIndexWriter = new SequentialWriter(this.descriptor.fileFor(BtiFormat.Components.ROW_INDEX), b.getIOOptions().writerOptions);
            this.rowIndexFHBuilder = IndexComponent.fileBuilder(BtiFormat.Components.ROW_INDEX, b).withMmappedRegionsCache(b.getMmappedRegionsCache());
            this.partitionIndexWriter = new SequentialWriter(this.descriptor.fileFor(BtiFormat.Components.PARTITION_INDEX), b.getIOOptions().writerOptions);
            this.partitionIndexFHBuilder = IndexComponent.fileBuilder(BtiFormat.Components.PARTITION_INDEX, b).withMmappedRegionsCache(b.getMmappedRegionsCache());
            this.partitionIndex = new PartitionIndexBuilder(this.partitionIndexWriter, this.partitionIndexFHBuilder);
            this.partitionIndexWriter.setPostFlushListener(this.partitionIndex::markPartitionIndexSynced);
            this.rowIndexWriter.setPostFlushListener(this.partitionIndex::markRowIndexSynced);
            dataWriter.setPostFlushListener(this.partitionIndex::markDataSynced);
        }

        public long append(DecoratedKey key, AbstractRowIndexEntry indexEntry) throws IOException {
            long position;
            this.bf.add(key);
            if (indexEntry.isIndexed()) {
                long indexStart = this.rowIndexWriter.position();
                try {
                    ByteBufferUtil.writeWithShortLength(key.getKey(), this.rowIndexWriter);
                    ((TrieIndexEntry)indexEntry).serialize(this.rowIndexWriter, this.rowIndexWriter.position(), this.descriptor.version);
                }
                catch (IOException e) {
                    throw new FSWriteError((Throwable)e, this.rowIndexWriter.getFile());
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("wrote index entry: {} at {}", (Object)indexEntry, (Object)indexStart);
                }
                position = indexStart;
            } else {
                position = indexEntry.position ^ 0xFFFFFFFFFFFFFFFFL;
            }
            this.partitionIndex.addEntry(key, position);
            return position;
        }

        public boolean buildPartial(long dataPosition, Consumer<PartitionIndex> callWhenReady) {
            return this.partitionIndex.buildPartial(callWhenReady, this.rowIndexWriter.position(), dataPosition);
        }

        @Override
        public void mark() {
            this.riMark = this.rowIndexWriter.mark();
            this.piMark = this.partitionIndexWriter.mark();
        }

        @Override
        public void resetAndTruncate() {
            this.rowIndexWriter.resetAndTruncate(this.riMark);
            this.partitionIndexWriter.resetAndTruncate(this.piMark);
        }

        @Override
        protected void doPrepare() {
            this.flushBf();
            this.rowIndexWriter.prepareToCommit();
            this.rowIndexFHBuilder.withLengthOverride(this.rowIndexWriter.getLastFlushOffset());
            this.complete();
        }

        void complete() throws FSWriteError {
            if (this.partitionIndexCompleted) {
                return;
            }
            try {
                this.partitionIndex.complete();
                this.partitionIndexCompleted = true;
            }
            catch (IOException e) {
                throw new FSWriteError((Throwable)e, this.partitionIndexWriter.getFile());
            }
        }

        PartitionIndex completedPartitionIndex() {
            this.complete();
            this.rowIndexFHBuilder.withLengthOverride(-1L);
            this.partitionIndexFHBuilder.withLengthOverride(-1L);
            try {
                return PartitionIndex.load(this.partitionIndexFHBuilder, this.metadata.getLocal().partitioner, false);
            }
            catch (IOException e) {
                throw new FSReadError((Throwable)e, this.partitionIndexWriter.getFile());
            }
        }

        @Override
        protected Throwable doCommit(Throwable accumulate) {
            return this.rowIndexWriter.commit(accumulate);
        }

        @Override
        protected Throwable doAbort(Throwable accumulate) {
            return this.rowIndexWriter.abort(accumulate);
        }

        @Override
        protected Throwable doPostCleanup(Throwable accumulate) {
            return Throwables.close(accumulate, this.bf, this.partitionIndex, this.rowIndexWriter, this.partitionIndexWriter);
        }
    }
}

