/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.restrictions.SingleColumnRestriction;
import org.apache.cassandra.cql3.restrictions.SingleRestriction;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;

public class Ordering {
    public final Expression expression;
    public final Direction direction;

    public Ordering(Expression expression, Direction direction) {
        this.expression = expression;
        this.direction = direction;
    }

    public static class Raw {
        final Expression expression;
        final Direction direction;

        public Raw(Expression expression, Direction direction) {
            this.expression = expression;
            this.direction = direction;
        }

        public Ordering bind(TableMetadata table, VariableSpecifications boundNames) {
            return new Ordering(this.expression.bind(table, boundNames), this.direction);
        }

        public static class Ann
        implements Expression {
            final ColumnIdentifier columnId;
            final Term.Raw vectorValue;

            Ann(ColumnIdentifier column, Term.Raw vectorValue) {
                this.columnId = column;
                this.vectorValue = vectorValue;
            }

            @Override
            public org.apache.cassandra.cql3.Ordering$Expression bind(TableMetadata table, VariableSpecifications boundNames) {
                ColumnMetadata column = table.getExistingColumn(this.columnId);
                Term value = this.vectorValue.prepare(table.keyspace, column);
                value.collectMarkerSpecification(boundNames);
                return new org.apache.cassandra.cql3.Ordering$Ann(column, value);
            }
        }

        public static class SingleColumn
        implements Expression {
            final ColumnIdentifier column;

            SingleColumn(ColumnIdentifier column) {
                this.column = column;
            }

            @Override
            public org.apache.cassandra.cql3.Ordering$Expression bind(TableMetadata table, VariableSpecifications boundNames) {
                return new org.apache.cassandra.cql3.Ordering$SingleColumn(table.getExistingColumn(this.column));
            }
        }

        public static interface Expression {
            public org.apache.cassandra.cql3.Ordering$Expression bind(TableMetadata var1, VariableSpecifications var2);
        }
    }

    public static enum Direction {
        ASC,
        DESC;

    }

    public static class Ann
    extends Expression {
        final Term vectorValue;

        public Ann(ColumnMetadata columnMetadata, Term vectorValue) {
            super(columnMetadata);
            this.vectorValue = vectorValue;
        }

        @Override
        public boolean hasNonClusteredOrdering() {
            return true;
        }

        @Override
        public SingleRestriction toRestriction() {
            return new SingleColumnRestriction.AnnRestriction(this.columnMetadata, this.vectorValue);
        }
    }

    public static class SingleColumn
    extends Expression {
        public SingleColumn(ColumnMetadata columnMetadata) {
            super(columnMetadata);
        }
    }

    public static abstract class Expression {
        protected final ColumnMetadata columnMetadata;

        public Expression(ColumnMetadata columnMetadata) {
            this.columnMetadata = columnMetadata;
        }

        public boolean hasNonClusteredOrdering() {
            return false;
        }

        public SingleRestriction toRestriction() {
            throw new UnsupportedOperationException();
        }

        public ColumnMetadata getColumn() {
            return this.columnMetadata;
        }
    }
}

