/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.analytics;

import org.gridkit.jvmtool.stacktrace.ThreadSnapshot;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadDumpAggregator;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadDumpAggregatorFactory;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadSnapshotFilter;

class FilterAggregatorFactory
implements ThreadDumpAggregator,
ThreadDumpAggregatorFactory {
    private final ThreadSnapshotFilter filter;
    private long total;
    private long matched;

    public FilterAggregatorFactory(ThreadSnapshotFilter filter) {
        this.filter = filter;
    }

    @Override
    public ThreadDumpAggregator newInstance() {
        return new FilterAggregatorFactory(this.filter);
    }

    @Override
    public void aggregate(ThreadSnapshot threadInfo) {
        ++this.total;
        if (this.filter.evaluate(threadInfo)) {
            ++this.matched;
        }
    }

    @Override
    public Object info() {
        return (double)this.matched / (double)this.total;
    }
}

