/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.Cloner;
import org.apache.cassandra.utils.memory.EnsureOnHeap;
import org.apache.cassandra.utils.memory.MemtableAllocator;
import org.apache.cassandra.utils.memory.MemtableBufferAllocator;
import org.apache.cassandra.utils.memory.MemtableCleaner;
import org.apache.cassandra.utils.memory.MemtablePool;

public class HeapPool
extends MemtablePool {
    public HeapPool(long maxOnHeapMemory, float cleanupThreshold, MemtableCleaner cleaner) {
        super(maxOnHeapMemory, 0L, cleanupThreshold, cleaner);
    }

    @Override
    public MemtableAllocator newAllocator() {
        return new Allocator(this);
    }

    @VisibleForTesting
    public static class Allocator
    extends MemtableBufferAllocator {
        private static final EnsureOnHeap ENSURE_NOOP = new EnsureOnHeap.NoOp();

        @VisibleForTesting
        public Allocator(HeapPool pool) {
            super(pool.onHeap.newAllocator(), pool.offHeap.newAllocator());
        }

        @Override
        public ByteBuffer allocate(int size, OpOrder.Group opGroup) {
            super.onHeap().allocate(size, opGroup);
            return ByteBuffer.allocate(size);
        }

        @Override
        public EnsureOnHeap ensureOnHeap() {
            return ENSURE_NOOP;
        }

        @Override
        public Cloner cloner(OpOrder.Group opGroup) {
            return this.allocator(opGroup);
        }
    }
}

