/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.acl;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.TestZooKeeperClientBuilder;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.ZooKeeperClientUtils;
import org.apache.distributedlog.ZooKeeperClusterTestCase;
import org.apache.distributedlog.impl.acl.ZKAccessControl;
import org.apache.distributedlog.impl.acl.ZKAccessControlManager;
import org.apache.distributedlog.thrift.AccessControlEntry;
import org.apache.distributedlog.util.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestZKAccessControlManager
extends ZooKeeperClusterTestCase {
    private static final Logger logger = LoggerFactory.getLogger(TestZKAccessControlManager.class);
    private DistributedLogConfiguration conf;
    private ZooKeeperClient zkc;
    private ScheduledExecutorService executorService;

    private URI createURI(String path) {
        return URI.create("distributedlog://127.0.0.1:" + zkPort + path);
    }

    @Before
    public void setup() throws Exception {
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.zkc = TestZooKeeperClientBuilder.newBuilder().uri(this.createURI("/")).build();
        this.conf = new DistributedLogConfiguration();
    }

    @After
    public void teardown() throws Exception {
        this.zkc.close();
        this.executorService.shutdown();
    }

    void setACL(ZKAccessControl accessControl) throws Exception {
        String zkPath = accessControl.getZKPath();
        if (null == this.zkc.get().exists(zkPath, false)) {
            accessControl.create(this.zkc);
        } else {
            accessControl.update(this.zkc);
        }
    }

    static void verifyStreamPermissions(ZKAccessControlManager zkcm, String stream, boolean allowWrite, boolean allowTruncate, boolean allowRelease, boolean allowDelete, boolean allowAcquire) throws Exception {
        Assert.assertEquals((Object)allowWrite, (Object)zkcm.allowWrite(stream));
        Assert.assertEquals((Object)allowTruncate, (Object)zkcm.allowTruncate(stream));
        Assert.assertEquals((Object)allowRelease, (Object)zkcm.allowRelease(stream));
        Assert.assertEquals((Object)allowDelete, (Object)zkcm.allowDelete(stream));
        Assert.assertEquals((Object)allowAcquire, (Object)zkcm.allowAcquire(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testZKAccessControlManager() throws Exception {
        String zkRootPath = "/test-zk-access-control-manager";
        String stream1 = "test-acm-1";
        String stream2 = "test-acm-2";
        logger.info("Creating ACL Manager for {}", (Object)zkRootPath);
        logger.info("Created ACL Manager for {}", (Object)zkRootPath);
        try (ZKAccessControlManager zkcm = new ZKAccessControlManager(this.conf, this.zkc, zkRootPath, this.executorService);){
            TestZKAccessControlManager.verifyStreamPermissions(zkcm, stream1, true, true, true, true, true);
            String zkPath1 = zkRootPath + "/" + stream1;
            AccessControlEntry ace1 = new AccessControlEntry();
            ace1.setDenyDelete(true);
            ZKAccessControl accessControl1 = new ZKAccessControl(ace1, zkPath1);
            this.setACL(accessControl1);
            logger.info("Create ACL for stream {} : {}", (Object)stream1, (Object)accessControl1);
            while (zkcm.allowDelete(stream1)) {
                Thread.sleep(100L);
            }
            TestZKAccessControlManager.verifyStreamPermissions(zkcm, stream1, true, true, true, false, true);
            ace1 = new AccessControlEntry();
            ace1.setDenyWrite(true);
            accessControl1 = new ZKAccessControl(ace1, zkPath1);
            this.setACL(accessControl1);
            logger.info("Update ACL for stream {} : {}", (Object)stream1, (Object)accessControl1);
            String zkPath2 = zkRootPath + "/" + stream2;
            AccessControlEntry ace2 = new AccessControlEntry();
            ace2.setDenyTruncate(true);
            ZKAccessControl accessControl2 = new ZKAccessControl(ace2, zkPath2);
            this.setACL(accessControl2);
            logger.info("Create ACL for stream {} : {}", (Object)stream2, (Object)accessControl2);
            while (zkcm.allowWrite(stream1)) {
                Thread.sleep(100L);
            }
            while (zkcm.allowTruncate(stream2)) {
                Thread.sleep(100L);
            }
            TestZKAccessControlManager.verifyStreamPermissions(zkcm, stream1, false, true, true, true, true);
            TestZKAccessControlManager.verifyStreamPermissions(zkcm, stream2, true, false, true, true, true);
            Utils.ioResult((CompletableFuture)ZKAccessControl.delete((ZooKeeperClient)this.zkc, (String)zkPath2));
            logger.info("Delete ACL for stream {}", (Object)stream2);
            while (!zkcm.allowTruncate(stream2)) {
                Thread.sleep(100L);
            }
            TestZKAccessControlManager.verifyStreamPermissions(zkcm, stream1, false, true, true, true, true);
            TestZKAccessControlManager.verifyStreamPermissions(zkcm, stream2, true, true, true, true, true);
            ZooKeeperClientUtils.expireSession(this.zkc, zkServers, 1000);
            ace1 = new AccessControlEntry();
            ace1.setDenyRelease(true);
            accessControl1 = new ZKAccessControl(ace1, zkPath1);
            this.setACL(accessControl1);
            logger.info("Update ACL for stream {} : {}", (Object)stream1, (Object)accessControl1);
            ace2 = new AccessControlEntry();
            ace2.setDenyAcquire(true);
            accessControl2 = new ZKAccessControl(ace2, zkPath2);
            this.setACL(accessControl2);
            logger.info("Created ACL for stream {} again : {}", (Object)stream2, (Object)accessControl2);
            while (zkcm.allowRelease(stream1)) {
                Thread.sleep(100L);
            }
            while (zkcm.allowAcquire(stream2)) {
                Thread.sleep(100L);
            }
            TestZKAccessControlManager.verifyStreamPermissions(zkcm, stream1, true, true, false, true, true);
            TestZKAccessControlManager.verifyStreamPermissions(zkcm, stream2, true, true, true, true, false);
        }
    }
}

