/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.SessionTracker;
import org.apache.zookeeper.server.ZooKeeperServerListener;
import org.apache.zookeeper.server.quorum.LeaderSessionTracker;
import org.apache.zookeeper.server.quorum.LearnerSessionTracker;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionTrackerCheckTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(SessionTrackerCheckTest.class);
    public static final int TICK_TIME = 1000;
    public static final int CONNECTION_TIMEOUT = 10000;
    private ConcurrentHashMap<Long, Integer> sessionsWithTimeouts = new ConcurrentHashMap();

    @BeforeEach
    public void setUp() throws Exception {
        this.sessionsWithTimeouts.clear();
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    @Test
    public void testLearnerSessionTracker() throws Exception {
        Expirer expirer = new Expirer(1L);
        LearnerSessionTracker tracker = new LearnerSessionTracker((SessionTracker.SessionExpirer)expirer, this.sessionsWithTimeouts, 1000, expirer.sid, true, this.testZKSListener());
        long sessionId = 185601517L;
        try {
            tracker.checkSession(sessionId, null);
            Assertions.fail((String)"Unknown session should have failed");
        }
        catch (KeeperException.SessionExpiredException sessionExpiredException) {
            // empty catch block
        }
        this.sessionsWithTimeouts.put(sessionId, 10000);
        try {
            tracker.checkSession(sessionId, null);
        }
        catch (Exception e) {
            Assertions.fail((String)"Global session should not fail");
        }
        sessionId = tracker.createSession(10000);
        try {
            tracker.checkSession(sessionId, null);
        }
        catch (Exception e) {
            Assertions.fail((String)"Local session should not fail");
        }
        this.sessionsWithTimeouts.put(sessionId, 10000);
        try {
            tracker.checkSession(sessionId, null);
        }
        catch (Exception e) {
            Assertions.fail((String)"Session during upgrade should not fail");
        }
        tracker = new LearnerSessionTracker((SessionTracker.SessionExpirer)expirer, this.sessionsWithTimeouts, 1000, expirer.sid, false, this.testZKSListener());
        sessionId = -559038737L;
        try {
            tracker.checkSession(sessionId, null);
        }
        catch (Exception e) {
            Assertions.fail((String)"Should not get any exception");
        }
    }

    @Test
    public void testLeaderSessionTracker() throws Exception {
        Expirer expirer = new Expirer(2L);
        LeaderSessionTracker tracker = new LeaderSessionTracker((SessionTracker.SessionExpirer)expirer, this.sessionsWithTimeouts, 1000, expirer.sid, true, this.testZKSListener());
        long sessionId = (expirer.sid + 1L << 56) + 1L;
        try {
            tracker.checkSession(sessionId, null);
        }
        catch (Exception e) {
            Assertions.fail((String)"local session from other server should not fail");
        }
        tracker.trackSession(sessionId, 10000);
        try {
            tracker.checkSession(sessionId, null);
        }
        catch (Exception e) {
            Assertions.fail((String)"Global session should not fail");
        }
        try {
            tracker.checkGlobalSession(sessionId, null);
        }
        catch (Exception e) {
            Assertions.fail((String)("Global session should not fail " + e));
        }
        sessionId = tracker.createSession(10000);
        try {
            tracker.checkSession(sessionId, null);
        }
        catch (Exception e) {
            Assertions.fail((String)"Local session on the leader should not fail");
        }
        tracker.trackSession(sessionId, 10000);
        try {
            tracker.checkSession(sessionId, null);
        }
        catch (Exception e) {
            Assertions.fail((String)"Session during upgrade should not fail");
        }
        try {
            tracker.checkGlobalSession(sessionId, null);
        }
        catch (Exception e) {
            Assertions.fail((String)("Global session should not fail " + e));
        }
        tracker = new LeaderSessionTracker((SessionTracker.SessionExpirer)expirer, this.sessionsWithTimeouts, 1000, expirer.sid, false, this.testZKSListener());
        sessionId = -559038737L;
        tracker.trackSession(sessionId, 10000);
        try {
            tracker.checkSession(sessionId, null);
        }
        catch (Exception e) {
            Assertions.fail((String)"Global session should not fail");
        }
        try {
            tracker.checkGlobalSession(sessionId, null);
        }
        catch (Exception e) {
            Assertions.fail((String)"Global session should not fail");
        }
        sessionId = (expirer.sid + 1L << 56) + 2L;
        try {
            tracker.checkSession(sessionId, null);
            Assertions.fail((String)"local session from other server should fail");
        }
        catch (KeeperException.SessionExpiredException sessionExpiredException) {
            // empty catch block
        }
        sessionId = (expirer.sid << 56) + 2L;
        try {
            tracker.checkSession(sessionId, null);
            Assertions.fail((String)"local session from the leader should fail");
        }
        catch (KeeperException.SessionExpiredException sessionExpiredException) {
            // empty catch block
        }
    }

    ZooKeeperServerListener testZKSListener() {
        return new ZooKeeperServerListener(){

            public void notifyStopping(String errMsg, int exitCode) {
            }
        };
    }

    private class Expirer
    implements SessionTracker.SessionExpirer {
        long sid;

        public Expirer(long sid) {
            this.sid = sid;
        }

        public void expire(SessionTracker.Session session) {
        }

        public long getServerId() {
            return this.sid;
        }
    }
}

