/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.fips.Mode;
import org.bouncycastle.crypto.fips.Padding;

public class FipsAlgorithm
implements Algorithm {
    private final Enum basicVariation;
    private final Enum additionalVariation;
    private final String name;

    FipsAlgorithm(String string) {
        this(string, null, null);
    }

    FipsAlgorithm(String string, Enum enum_) {
        this(string, enum_, null);
    }

    FipsAlgorithm(FipsAlgorithm fipsAlgorithm, Enum enum_) {
        this(fipsAlgorithm.getName(), enum_, null);
    }

    FipsAlgorithm(FipsAlgorithm fipsAlgorithm, Enum enum_, Padding padding) {
        this(fipsAlgorithm.getName(), enum_, padding);
    }

    FipsAlgorithm(String string, Enum enum_, Padding padding) {
        this.basicVariation = enum_;
        this.additionalVariation = padding;
        this.name = enum_ instanceof Mode ? string + "/" + ((Mode)enum_).getBaseMode().getCode() + (padding != null ? "/" + padding.getBasePadding().getCode() : "") : (enum_ instanceof FipsKDF.PRF ? string + "(" + ((FipsKDF.PRF)enum_).getAlgorithm().getName() + ")" : (enum_ instanceof FipsKDF.AgreementKDFPRF ? string + "(" + ((FipsKDF.AgreementKDFPRF)enum_).getAlgorithm().getName() + ")" : string));
    }

    Enum basicVariation() {
        return this.basicVariation;
    }

    Enum additionalVariation() {
        return this.additionalVariation;
    }

    public String getName() {
        return this.name;
    }

    public final boolean requiresAlgorithmParameters() {
        return this.basicVariation instanceof Mode && ((Mode)this.basicVariation).getBaseMode().expectsIV();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FipsAlgorithm)) {
            return false;
        }
        FipsAlgorithm fipsAlgorithm = (FipsAlgorithm)object;
        if (this.additionalVariation != null ? !this.additionalVariation.equals(fipsAlgorithm.additionalVariation) : fipsAlgorithm.additionalVariation != null) {
            return false;
        }
        if (this.basicVariation != null ? !this.basicVariation.equals(fipsAlgorithm.basicVariation) : fipsAlgorithm.basicVariation != null) {
            return false;
        }
        return this.name.equals(fipsAlgorithm.name);
    }

    public int hashCode() {
        int n = this.name.hashCode();
        n = 31 * n + (this.additionalVariation != null ? this.additionalVariation.hashCode() : 0);
        n = 31 * n + (this.basicVariation != null ? this.basicVariation.hashCode() : 0);
        return n;
    }

    byte[] createDefaultIvIfNecessary(int n, SecureRandom secureRandom) {
        return ((Mode)this.basicVariation()).createDefaultIvIfNecessary(n, secureRandom);
    }

    byte[] createIvIfNecessary(int n, SecureRandom secureRandom) {
        return ((Mode)this.basicVariation()).createIvIfNecessary(n, secureRandom);
    }
}

