/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.metric;

import java.util.Map;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.metric.AvgMinMaxPercentileCounter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AvgMinMaxPercentileCounterTest
extends ZKTestCase {
    private AvgMinMaxPercentileCounter testCounter;

    @BeforeEach
    public void initCounter() {
        this.testCounter = new AvgMinMaxPercentileCounter("test");
    }

    private void addDataPoints() {
        for (int i = 0; i < 1000; ++i) {
            this.testCounter.add((long)i);
        }
    }

    @Test
    public void testReset() {
        this.addDataPoints();
        this.testCounter.reset();
        Map values = this.testCounter.values();
        Assertions.assertEquals((int)9, (int)values.size(), (String)"There should be 9 values in the set");
        Assertions.assertEquals((Object)0.0, values.get("avg_test"), (String)"should avg=0");
        Assertions.assertEquals((Object)0L, values.get("min_test"), (String)"should have min=0");
        Assertions.assertEquals((Object)0L, values.get("max_test"), (String)"should have max=0");
        Assertions.assertEquals((Object)0L, values.get("cnt_test"), (String)"should have cnt=0");
        Assertions.assertEquals((Object)0L, values.get("sum_test"), (String)"should have sum=0");
        Assertions.assertEquals((Object)0L, values.get("p50_test"), (String)"should have p50=0");
        Assertions.assertEquals((Object)0L, values.get("p95_test"), (String)"should have p95=0");
        Assertions.assertEquals((Object)0L, values.get("p99_test"), (String)"should have p99=0");
        Assertions.assertEquals((Object)0L, values.get("p999_test"), (String)"should have p999=0");
    }

    @Test
    public void testValues() {
        this.addDataPoints();
        Map values = this.testCounter.values();
        Assertions.assertEquals((int)9, (int)values.size(), (String)"There should be 9 values in the set");
        Assertions.assertEquals((Object)499.5, values.get("avg_test"), (String)"should avg=499.5");
        Assertions.assertEquals((Object)0L, values.get("min_test"), (String)"should have min=0");
        Assertions.assertEquals((Object)999L, values.get("max_test"), (String)"should have max=999");
        Assertions.assertEquals((Object)1000L, values.get("cnt_test"), (String)"should have cnt=1000");
        Assertions.assertEquals((Object)499500L, values.get("sum_test"), (String)"should have sum=999*500");
        Assertions.assertEquals((Object)500L, values.get("p50_test"), (String)"should have p50=500");
        Assertions.assertEquals((Object)950L, values.get("p95_test"), (String)"should have p95=950");
        Assertions.assertEquals((Object)990L, values.get("p99_test"), (String)"should have p99=990");
        Assertions.assertEquals((Object)999L, values.get("p999_test"), (String)"should have p999=999");
    }
}

