/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.filter;

import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.filter.DestinationFilter;
import org.apache.activemq.filter.DestinationPath;

public class WildcardDestinationFilter
extends DestinationFilter {
    private String[] prefixes;
    private byte destinationType;

    public WildcardDestinationFilter(String[] prefixes, byte destinationType) {
        this.prefixes = new String[prefixes.length];
        for (int i2 = 0; i2 < prefixes.length; ++i2) {
            String prefix = prefixes[i2];
            if (prefix.equals("*")) continue;
            this.prefixes[i2] = prefix;
        }
        this.destinationType = destinationType;
    }

    @Override
    public boolean matches(ActiveMQDestination destination) {
        int length;
        if (destination.getDestinationType() != this.destinationType) {
            return false;
        }
        String[] path = DestinationPath.getDestinationPaths(destination);
        if (path.length == (length = this.prefixes.length)) {
            for (int i2 = 0; i2 < length; ++i2) {
                String prefix = this.prefixes[i2];
                if (prefix == null || prefix.equals(path[i2])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getText() {
        return DestinationPath.toString(this.prefixes);
    }

    public String toString() {
        return super.toString() + "[destination: " + this.getText() + "]";
    }

    @Override
    public boolean isWildcard() {
        return true;
    }
}

