use bitflags::bitflags as inner_bitflags;
use core::{mem, ops::Deref, slice};

macro_rules! bitflags {
    (
        $(#[$outer:meta])*
        pub struct $BitFlags:ident: $T:ty {
            $(
                $(#[$inner:ident $($args:tt)*])*
                const $Flag:ident = $value:expr;
            )+
        }
    ) => {
        
        inner_bitflags! {
            #[derive(PartialEq, Eq, PartialOrd, Ord, Hash, Debug, Clone, Copy, Default)]
            $(#[$outer])*
            pub struct $BitFlags: $T {
                $(
                    $(#[$inner $($args)*])*
                    const $Flag = $value;
                )+
            }
        }

        impl $BitFlags {
            #[deprecated = "use the safe `from_bits_retain` method instead"]
            pub unsafe fn from_bits_unchecked(bits: $T) -> Self {
                Self::from_bits_retain(bits)
            }
        }

        
        
        $(
            $(#[$inner $($args)*])*
            pub const $Flag: $BitFlags = $BitFlags::$Flag;
        )+
    }
}

pub const CLOCK_REALTIME: usize = 1;
pub const CLOCK_MONOTONIC: usize = 4;

bitflags! {
    pub struct EventFlags: usize {
        const EVENT_NONE = 0;
        const EVENT_READ = 1;
        const EVENT_WRITE = 2;
    }
}

pub const F_DUPFD: usize = 0;
pub const F_GETFD: usize = 1;
pub const F_SETFD: usize = 2;
pub const F_GETFL: usize = 3;
pub const F_SETFL: usize = 4;

pub const FUTEX_WAIT: usize = 0;
pub const FUTEX_WAKE: usize = 1;
pub const FUTEX_REQUEUE: usize = 2;
pub const FUTEX_WAIT64: usize = 3;


pub const SKMSG_FRETURNFD: usize = 0;


pub const SKMSG_PROVIDE_MMAP: usize = 1;


pub const SKMSG_FOBTAINFD: usize = 2;


bitflags::bitflags! {
    #[derive(Clone, Copy, Debug)]
    pub struct SendFdFlags: usize {
        
        
        
        
        
        const EXCLUSIVE = 1;
    }
}
bitflags::bitflags! {
    #[derive(Clone, Copy, Debug)]
    pub struct FobtainFdFlags: usize {
        
        
        const MANUAL_FD = 1;

        
        
        const EXCLUSIVE = 2;

        
        
    }
}

bitflags! {
    pub struct MapFlags: usize {
        
        
        const PROT_NONE = 0x0000_0000;

        const PROT_EXEC = 0x0001_0000;
        const PROT_WRITE = 0x0002_0000;
        const PROT_READ = 0x0004_0000;

        const MAP_SHARED = 0x0001;
        const MAP_PRIVATE = 0x0002;

        const MAP_FIXED = 0x0004;
        const MAP_FIXED_NOREPLACE = 0x000C;

        
        
        
        
        
        
        
        
        
        
        
        const MAP_LAZY = 0x0010;
    }
}
bitflags! {
    pub struct MunmapFlags: usize {
        
        
        
        
        const NEEDS_SYNC = 1;
    }
}

pub const MODE_TYPE: u16 = 0xF000;
pub const MODE_DIR: u16 = 0x4000;
pub const MODE_FILE: u16 = 0x8000;
pub const MODE_SYMLINK: u16 = 0xA000;
pub const MODE_FIFO: u16 = 0x1000;
pub const MODE_CHR: u16 = 0x2000;

pub const MODE_PERM: u16 = 0x0FFF;
pub const MODE_SETUID: u16 = 0o4000;
pub const MODE_SETGID: u16 = 0o2000;

pub const O_RDONLY: usize = 0x0001_0000;
pub const O_WRONLY: usize = 0x0002_0000;
pub const O_RDWR: usize = 0x0003_0000;
pub const O_NONBLOCK: usize = 0x0004_0000;
pub const O_APPEND: usize = 0x0008_0000;
pub const O_SHLOCK: usize = 0x0010_0000;
pub const O_EXLOCK: usize = 0x0020_0000;
pub const O_ASYNC: usize = 0x0040_0000;
pub const O_FSYNC: usize = 0x0080_0000;
pub const O_CLOEXEC: usize = 0x0100_0000;
pub const O_CREAT: usize = 0x0200_0000;
pub const O_TRUNC: usize = 0x0400_0000;
pub const O_EXCL: usize = 0x0800_0000;
pub const O_DIRECTORY: usize = 0x1000_0000;
pub const O_STAT: usize = 0x2000_0000;
pub const O_SYMLINK: usize = 0x4000_0000;
pub const O_NOFOLLOW: usize = 0x8000_0000;
pub const O_ACCMODE: usize = O_RDONLY | O_WRONLY | O_RDWR;



bitflags! {
    pub struct PtraceFlags: u64 {
        
        
        const PTRACE_STOP_PRE_SYSCALL = 0x0000_0000_0000_0001;
        
        const PTRACE_STOP_POST_SYSCALL = 0x0000_0000_0000_0002;
        
        
        const PTRACE_STOP_SINGLESTEP = 0x0000_0000_0000_0004;
        
        
        const PTRACE_STOP_SIGNAL = 0x0000_0000_0000_0008;
        
        
        const PTRACE_STOP_BREAKPOINT = 0x0000_0000_0000_0010;
        
        const PTRACE_STOP_EXIT = 0x0000_0000_0000_0020;

        const PTRACE_STOP_MASK = 0x0000_0000_0000_00FF;


        
        
        const PTRACE_EVENT_CLONE = 0x0000_0000_0000_0100;

        
        const PTRACE_EVENT_ADDRSPACE_SWITCH = 0x0000_0000_0000_0200;

        const PTRACE_EVENT_MASK = 0x0000_0000_0000_0F00;

        
        
        const PTRACE_FLAG_IGNORE = 0x0000_0000_0000_1000;

        const PTRACE_FLAG_MASK = 0x0000_0000_0000_F000;
    }
}
impl Deref for PtraceFlags {
    type Target = [u8];
    fn deref(&self) -> &Self::Target {
        
        unsafe {
            slice::from_raw_parts(&self.bits() as *const _ as *const u8, mem::size_of::<u64>())
        }
    }
}

pub const SEEK_SET: usize = 0;
pub const SEEK_CUR: usize = 1;
pub const SEEK_END: usize = 2;

pub const SIGHUP: usize = 1;
pub const SIGINT: usize = 2;
pub const SIGQUIT: usize = 3;
pub const SIGILL: usize = 4;
pub const SIGTRAP: usize = 5;
pub const SIGABRT: usize = 6;
pub const SIGBUS: usize = 7;
pub const SIGFPE: usize = 8;
pub const SIGKILL: usize = 9;
pub const SIGUSR1: usize = 10;
pub const SIGSEGV: usize = 11;
pub const SIGUSR2: usize = 12;
pub const SIGPIPE: usize = 13;
pub const SIGALRM: usize = 14;
pub const SIGTERM: usize = 15;
pub const SIGSTKFLT: usize = 16;
pub const SIGCHLD: usize = 17;
pub const SIGCONT: usize = 18;
pub const SIGSTOP: usize = 19;
pub const SIGTSTP: usize = 20;
pub const SIGTTIN: usize = 21;
pub const SIGTTOU: usize = 22;
pub const SIGURG: usize = 23;
pub const SIGXCPU: usize = 24;
pub const SIGXFSZ: usize = 25;
pub const SIGVTALRM: usize = 26;
pub const SIGPROF: usize = 27;
pub const SIGWINCH: usize = 28;
pub const SIGIO: usize = 29;
pub const SIGPWR: usize = 30;
pub const SIGSYS: usize = 31;

bitflags! {
    pub struct WaitFlags: usize {
        const WNOHANG =    0x01;
        const WUNTRACED =  0x02;
        const WCONTINUED = 0x08;
    }
}

pub const ADDRSPACE_OP_MMAP: usize = 0;
pub const ADDRSPACE_OP_MUNMAP: usize = 1;
pub const ADDRSPACE_OP_MPROTECT: usize = 2;
pub const ADDRSPACE_OP_TRANSFER: usize = 3;


pub fn wifstopped(status: usize) -> bool {
    (status & 0xff) == 0x7f
}


pub fn wstopsig(status: usize) -> usize {
    (status >> 8) & 0xff
}


pub fn wifcontinued(status: usize) -> bool {
    status == 0xffff
}


pub fn wifsignaled(status: usize) -> bool {
    ((status & 0x7f) + 1) as i8 >= 2
}


pub fn wtermsig(status: usize) -> usize {
    status & 0x7f
}


pub fn wifexited(status: usize) -> bool {
    wtermsig(status) == 0
}


pub fn wexitstatus(status: usize) -> usize {
    (status >> 8) & 0xff
}


pub fn wcoredump(status: usize) -> bool {
    (status & 0x80) != 0
}

bitflags! {
    pub struct MremapFlags: usize {
        const FIXED = 1;
        const FIXED_REPLACE = 3;
        
        
        const KEEP_OLD = 1 << 2;
        
    }
}
bitflags! {
    pub struct RwFlags: u32 {
        const NONBLOCK = 1;
        const APPEND = 2;
        
        
    }
}
bitflags! {
    pub struct SigcontrolFlags: usize {
        
        
        
        const INHIBIT_DELIVERY = 1;
    }
}
bitflags! {
    pub struct CallFlags: usize {
        
        const BIT0 = 1 << 0;
        const BIT1 = 1 << 1;
        const BIT2 = 1 << 2;
        const BIT3 = 1 << 3;
        const BIT4 = 1 << 4;
        const BIT5 = 1 << 5;
        const BIT6 = 1 << 6;
        const BIT7 = 1 << 7;
    }
}
