% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zcurve_density.R
\name{control_density_v1}
\alias{control_density_v1}
\title{Control settings for the original z-curve density algorithm}
\arguments{
\item{version}{Set to \code{1} to fit the original version of z-curve.
Defaults to \code{2} = the updated version of z-curve. For its settings
page go to \link{control_density}.}

\item{model}{A type of model to be fitted, defaults to \code{"KD1"}
(the only possibility)}

\item{sig_level}{An alpha level of the test statistics, defaults to
\code{.05}}

\item{a}{A beginning of fitting interval, defaults to
\code{qnorm(sig_level/2,lower.tail = F)}}

\item{b}{An end of fitting interval, defaults to \code{6}}

\item{K}{Number of mixture components, defaults to \code{3}}

\item{max_iter}{A maximum number of iterations for the \link[stats]{nlminb}
optimization for fitting mixture model, defaults to \code{150}}

\item{max_eval}{A maximum number of evaluation for the \link[stats]{nlminb}
optimization for fitting mixture model, defaults to \code{300}}

\item{criterion}{A criterion to terminate \link[stats]{nlminb} optimization,
defaults to \code{1e-10}}

\item{bw}{A bandwidth of the kernel density estimation, defaults to \code{"nrd0"}}
}
\description{
All settings are passed to the density fitting
algorithm. All unspecified settings are set to the default value.
Setting \code{model = "KD1"} sets all settings to the default
value irrespective of any other setting and fits z-curve as described
in \insertCite{zcurve1;textual}{zcurve}.
}
\examples{
# to increase the number of iterations
ctrl <- list(
   version   = 1,
   max_iter  = 300
)
\dontrun{zcurve(OSC.z, method = "density", control = ctrl)}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=zcurve]{zcurve()}}, \link{control_density}, \link{control_EM}
}
