% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivw_xd_index.R
\name{ivw_xd_index}
\alias{ivw_xd_index}
\title{ivw_xd_index - Inverse Variance Weighted (IVW) Expertise Diversity (xd-) Index}
\usage{
ivw_xd_index(df, cat, id, cit, vfc = NULL, type = "h", dlm = ";", plot = FALSE)
}
\arguments{
\item{df}{Data frame object containing bibliometric data. This data frame must
have at least three columns: one for categories, one for unique IDs, and one
for citation counts. Each row in the data frame should represent a document
or publication.}

\item{cat}{Character string specifying the name of the column in "df" that
contains categories. Each cell in this column may contain no categories (missing),
a single category or multiple categories separated by a specified delimiter.}

\item{id}{Character string specifying the name of the column in "df" that contains
unique identifiers for each document. Each cell in this column must contain a single
ID (unless missing) and not multiple IDs.}

\item{cit}{Character string specifying the name of the column in "df" that
contains the number of citations each document has received. Citations must
be represented as integers. Each cell in this column should contain a single
integer value (unless missing) representing the citation count for the
corresponding document.}

\item{vfc}{Data frame with columns 'cat' and 'var_cit'. Optionally required
for using population variances.}

\item{type}{"h" (default) for Hirsch's h-type index or "g" for Egghe's g-type index.}

\item{dlm}{Character string specifying the delimiter used in the "cat" column
to separate multiple categories within a single cell. The delimiter should be
consistent across the entire "cat" column. Common delimiters include ";" (default), "/",
":", and ",".}

\item{plot}{Logical value indicating whether to generate and display a plot of
the xd-index calculation. Set to "TRUE" or "T" to generate the plot, and "FALSE" (default)
or "F" to skip plot generation.}
}
\value{
IVW xd-index magnitude, core categories, and optional plot.
}
\description{
Calculate IVW adjusted xd-index for an institution using bibliometric data from
an edge list, with an optional visualisation of ranked citation scores. The function
is suitable for including inside loops when plotting parameter is set to "FALSE" or "F".
}
\examples{
# Load example data
data(WoSdata)

# Calculate ivw xd-index with plot
ivw_xd_index(df = WoSdata,
        id = "UT.Unique.WOS.ID",
        cat = "WoS.Categories",
        cit = "Times.Cited.WoS.Core",
        plot = TRUE)

}
