% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_qq.R
\name{qq_plot}
\alias{qq_plot}
\alias{prm_qq}
\alias{eta_qq}
\alias{res_qq}
\alias{cov_qq}
\title{QQ plots of ETA and residuals}
\usage{
prm_qq(
  xpdb,
  mapping = NULL,
  drop_fixed = TRUE,
  type = "p",
  title = "QQ plot of parameters | @run",
  subtitle = "Based on @nind individuals",
  caption = "@dir",
  tag = NULL,
  log = NULL,
  guide = TRUE,
  facets,
  .problem,
  quiet,
  ...
)

eta_qq(
  xpdb,
  mapping = NULL,
  drop_fixed = TRUE,
  type = "p",
  title = "QQ plot of etas | @run",
  subtitle = "Based on @nind individuals, Eta shrink: @etashk",
  caption = "@dir",
  tag = NULL,
  log = NULL,
  guide = TRUE,
  facets,
  .problem,
  quiet,
  ...
)

res_qq(
  xpdb,
  mapping = NULL,
  res = "CWRES",
  type = "p",
  title = "QQ plot of @sample | @run",
  subtitle = "Based on @nobs observations",
  caption = "@dir",
  tag = NULL,
  log = NULL,
  guide = TRUE,
  facets,
  .problem,
  quiet,
  ...
)

cov_qq(
  xpdb,
  mapping = NULL,
  drop_fixed = TRUE,
  type = "p",
  title = "QQ plot of continuous covariates | @run",
  subtitle = "Based on @nind individuals",
  caption = "@dir",
  tag = NULL,
  log = NULL,
  guide = TRUE,
  facets,
  .problem,
  quiet,
  ...
)
}
\arguments{
\item{xpdb}{An xpose database object.}

\item{mapping}{List of aesthetics mappings to be used for the xpose plot 
(e.g. \code{point_color}).}

\item{drop_fixed}{Should columns that only have a single unique value 
(i.e. fixed) be dropped.}

\item{type}{String setting the type of plot. Can only be points 'p'.}

\item{title}{Plot title. Use \code{NULL} to remove.}

\item{subtitle}{Plot subtitle. Use \code{NULL} to remove.}

\item{caption}{Page caption. Use \code{NULL} to remove.}

\item{tag}{Plot identification tag. Use \code{NULL} to remove.}

\item{log}{String assigning logarithmic scale to axes, can be either '', 
'x', y' or 'xy'.}

\item{guide}{Should the guide (e.g. reference line) be displayed.}

\item{facets}{Either a character string to use \code{\link[ggforce]{facet_wrap_paginate}}
or a formula to use \code{\link[ggforce]{facet_grid_paginate}}.}

\item{.problem}{The $problem number to be used. By default returns 
the last estimation problem.}

\item{quiet}{Logical, if \code{FALSE} messages are printed to the console.}

\item{...}{Any additional aesthetics to be passed on \code{xplot_scatter}.}

\item{res}{Only used for \code{res_qq}. Defines the type of residual to be used. Default is "CWRES".}
}
\description{
QQ plots of the ETA and model residuals.
}
\section{Layers mapping}{

Plots can be customized by mapping arguments to specific layers. The naming convention is 
layer_option where layer is one of the names defined in the list below and option is 
any option supported by this layer e.g. point_color = 'blue', etc.
\itemize{
  \item point: options to \code{geom_point}
  \item guide: options to \code{geom_abline}
  \item xscale: options to \code{scale_x_continuous} or \code{scale_x_log10}
  \item yscale: options to \code{scale_y_continuous} or \code{scale_y_log10}
}
}

\section{Faceting}{

Every xpose plot function has built-in faceting functionalities. Faceting arguments 
are passed to the functions \code{\link[ggforce]{facet_wrap_paginate}} when the \code{facets} 
argument is a character string (e.g. \code{facets = c('SEX', 'MED1')}) or 
\code{\link[ggforce]{facet_grid_paginate}} when facets is a formula (e.g. \code{facets = SEX~MED1}).
All xpose plot functions accept all the arguments for the \code{\link[ggforce]{facet_wrap_paginate}} 
and \code{\link[ggforce]{facet_grid_paginate}} functions e.g. \code{dv_vs_ipred(xpdb_ex_pk, 
facets = SEX~MED1, ncol = 3, nrow = 3, page = 1, margins = TRUE, labeller = 'label_both')}.

Faceting options can either be defined in plot functions (e.g. \code{dv_vs_ipred(xpdb_ex_pk, 
facets = 'SEX')}) or assigned globally to an xpdb object via the \code{xp_theme} (e.g. \code{xpdb 
<- update_themes(xpdb_ex_pk, xp_theme = list(facets = 'SEX'))}). In the latter example all plots 
generate from this xpdb will automatically be stratified by `SEX`.

By default, some plot functions use a custom stratifying variable named `variable`, e.g. 
\code{eta_distrib()}. When using the \code{facets} argument, `variable` needs to be added manually 
e.g. \code{facets = c('SEX', 'variable')} or \code{facets = c('SEX', 'variable')}, but is optional, 
when using the \code{facets} argument in \code{xp_theme} variable is automatically added whenever needed.
}

\section{Template titles}{

Template titles can be used to create highly informative diagnostics plots. 
They can be applied to any plot title, subtitle, caption and tag. Template titles 
are defined via a single string containing key variables staring with a `@` (e.g. `@ofv`)
which will be replaced by their actual value when rendering the plot.
For example `'@run, @nobs observations in @nind subjects'` would become 
`'run001, 1022 observations in 74 subjects'`. The available key variables 
are listed under \code{\link{template_titles}}.
}

\examples{
# QQ plot of parameters
prm_qq(xpdb_ex_pk)

# QQ plot of eta
eta_qq(xpdb_ex_pk)

# QQ plot of residuals
res_qq(xpdb_ex_pk, res = c('IWRES', 'CWRES'))

# QQ plot of continuous covariates
cov_qq(xpdb_ex_pk)

}
\seealso{
\code{\link{xplot_distrib}}
}
