% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worldmet-package.R
\docType{package}
\name{worldmet-package}
\alias{worldmet}
\alias{worldmet-package}
\title{worldmet: Import Surface Meteorological Data from NOAA}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Functions to import data from more than 30,000 surface meteorological sites around the world managed by the National Oceanic and Atmospheric Administration (NOAA) Global Historical Climate Network (GHCN) and Integrated Surface Database (ISD).
}
\details{
This package contains functions to import surface meteorological
data from over 30,000 sites around the world. These data are curated by
NOAA as part of the Global Historical Climate Network (GHCN), which
replaced the Integrated Surface Database (ISD) in 2025.

If you access these data using the \code{worldmet} package please give full
acknowledgement to NOAA. Users should also take a note of the usage
restrictions.

These data work well with the \code{openair} package that has been developed to
analyse air pollution data.
}
\references{
For general information about the GHCNh, see
\url{https://www.ncei.noaa.gov/products/global-historical-climatology-network-hourly}.

For general information about the legacy ISD service, see
\url{https://www.ncei.noaa.gov/products/land-based-station/integrated-surface-database}.
}
\seealso{
See \url{https://github.com/openair-project/openair} for information on
the related \code{openair} package.
}
\author{
\strong{Maintainer}: David Carslaw \email{david.carslaw@york.ac.uk} (\href{https://orcid.org/0000-0003-0991-950X}{ORCID})

Authors:
\itemize{
  \item Jack Davison \email{jack.davison@ricardo.com} (\href{https://orcid.org/0000-0003-2653-6615}{ORCID})
}

}
\keyword{internal}
