% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hampel.R
\name{hampel_anomalies}
\alias{hampel_anomalies}
\title{Identify anomalies using the Hampel filter}
\usage{
hampel_anomalies(y, bandwidth, k = 3)
}
\arguments{
\item{y}{numeric vector containing time series}

\item{bandwidth}{integer width of the window around each observation}

\item{k}{numeric number of standard deviations to declare an outlier}
}
\value{
logical vector identifying which observations are anomalies.
}
\description{
The Hampel filter is designed to find anomalies in time series data using
mean absolute deviations in the vicinity of each observation.
}
\details{
First, a moving median is calculated using windows of size
\code{2 * bandwidth + 1}. Then the median absolute deviations from
this moving median are calculated in the same moving windows.
A point is declared an anomaly if its MAD is value is more than \code{k} standard
deviations. The MAD is converted to a standard deviation using MAD * 1.482602,
which holds for normally distributed data.
The first \code{bandwidth} and last \code{bandwidth} observations cannot
be declared anomalies.
}
\examples{
set.seed(1)
df <- tibble(
  time = seq(41),
  y = c(rnorm(20), 5, rnorm(20))
) |>
  mutate(hampel = hampel_anomalies(y, bandwidth = 3, k = 4))
df |> ggplot(aes(x = time, y = y)) +
  geom_line() +
  geom_point(data = df |> filter(hampel), col = "red")
}
\references{
Rob J Hyndman (2026) "That's weird: Anomaly detection using R", Section 9.2,
\url{https://OTexts.com/weird/}.
}
\author{
Rob J Hyndman
}
