% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ids_bulk.R
\name{ids_bulk}
\alias{ids_bulk}
\title{Download and Process Bulk Data File for International Debt Statistics}
\usage{
ids_bulk(
  file_url,
  file_path = tempfile(fileext = ".xlsx"),
  quiet = FALSE,
  timeout = getOption("timeout", 60),
  warn_size = TRUE
)
}
\arguments{
\item{file_url}{A character string specifying the URL of the Excel file to
download. This parameter is required (see \link{ids_bulk_files}).}

\item{file_path}{An optional character string specifying the file path where
the downloaded file will be saved. Defaults to a temporary file with \code{.xlsx}
extension. The file will automatically be deleted after processing.}

\item{quiet}{A logical parameter indicating whether messages should be
printed to the console.}

\item{timeout}{An integer specifying the timeout in seconds for downloading
the file. Defaults to the current R timeout setting.}

\item{warn_size}{A logical parameter indicating whether to warn about large
downloads. Defaults to TRUE.}
}
\value{
A tibble containing processed debt statistics data with the following
columns:
\describe{
\item{entity_id}{The unique identifier for the entity (e.g., "ZMB").}
\item{series_id}{The unique identifier for the series (e.g.,
"DT.DOD.DPPG.CD").}
\item{counterpart_id}{The unique identifier for the counterpart series.}
\item{year}{The year corresponding to the data (as an integer).}
\item{value}{The numeric value representing the statistic for the given
entity, series, counterpart, and year.}
}
}
\description{
This function downloads a data file from the World Bank International Debt
Statistics (IDS), reads and processes the data into a tidy format.
}
\examples{
\dontshow{if (curl::has_internet() && rlang::is_installed("readxl")) withAutoprint(\{ # examplesIf}
\dontrun{
available_files <- ids_bulk_files()
data <- ids_bulk(
  available_files$file_url[1]
)
}
\dontshow{\}) # examplesIf}
}
