% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{vetr}
\alias{vetr}
\title{Verify Function Arguments Meet Structural Requirements}
\usage{
vetr(..., .VETR_SETTINGS = NULL)
}
\arguments{
\item{...}{vetting expressions, each will be matched to the enclosing
function formals as with \code{\link[=match.call]{match.call()}} and will be used to validate the
value of the matching formal.}

\item{.VETR_SETTINGS}{a settings list as produced by \code{\link[=vetr_settings]{vetr_settings()}}, or
NULL to use the default settings.  Note that this means you cannot use
\code{vetr} with a function that takes a \code{.VETR_SETTINGS} argument}
}
\value{
TRUE if validation succeeds, otherwise \code{stop} with error message
detailing nature of failure.
}
\description{
Use vetting expressions to enforce structural requirements for function
arguments.  Works just like \code{\link[=vet]{vet()}}, except that the formals of the
enclosing function automatically matched to the vetting expressions provided
in \code{...}.
}
\details{
Only named arguments may be vetted; in other words it is not possible to vet
arguments passed via \code{...}.
}
\note{
\code{vetr} will force evaluation of any arguments that are being
checked (you may omit arguments that should not be evaluate from
\code{vetr})
}
\section{Vetting Expressions}{


Vetting expressions can be template tokens, standard tokens, or any
expression built with them, \code{||}, \code{&&}, and parentheses.  Template tokens
are R objects that define the required structure, much like the \code{FUN.VALUE}
argument to \code{\link[=vapply]{vapply()}}.  Standard tokens are R expressions evaluated and
checked for being \code{all(TRUE)}.

Standard tokens are distinguished from templates by whether they reference
the \code{.} symbol or not.  If you have a need to reference an object bound to
\code{.} in a vetting expression, you can escape the \code{.}  with an extra dot (i.e.
use \code{..}, and \code{...} for \code{..},  and so forth for symbols comprising only
dots).  If you use standard tokens in your packages you will need to include
\code{utils::globalVariables(".")} as a top-level call to avoid the "no visible
binding for global variable '.'"' R CMD check NOTE.  Standard tokens that
return a string like e.g. \code{all.equal(x, .)} will result in that string being
incorporated into the error message.

See \code{vignette('vetr', package='vetr')} and examples for details on how
to craft vetting expressions.
}

\examples{
## Look at `?vet` examples for more details on how to craft
## vetting expressions.

fun1 <- function(x, y) {
  vetr(integer(), LGL.1)
  TRUE   # do some work
}
fun1(1:10, TRUE)
try(fun1(1:10, 1:10))

## only vet the second argument
fun2 <- function(x, y) {
  vetr(y=LGL.1)
  TRUE   # do some work
}
try(fun2(letters, 1:10))

## Nested templates; note, in packages you should consider
## defining templates outside of `vet` or `vetr` so that
## they are computed on load rather that at runtime
tpl <- list(numeric(1L), matrix(integer(), 3))
val.1 <- list(runif(1), rbind(1:10, 1:10, 1:10))
val.2 <- list(runif(1), cbind(1:10, 1:10, 1:10))
fun3 <- function(x, y) {
  vetr(x=tpl, y=tpl && ncol(.[[2]]) == ncol(x[[2]]))
  TRUE   # do some work
}
fun3(val.1, val.1)
try(fun3(val.1, val.2))
val.1.a <- val.1
val.1.a[[2]] <- val.1.a[[2]][, 1:8]
try(fun3(val.1, val.1.a))
}
\seealso{
\code{\link[=vet]{vet()}}, in particular \code{example(vet)}.
}
