% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surface_integral_z.R
\name{surface_integral_z}
\alias{surface_integral_z}
\title{Surface integral over a graph z = g(x, y)}
\usage{
surface_integral_z(
  gfun,
  xlim,
  ylim,
  nx = 160,
  ny = 160,
  scalar_phi = NULL,
  vector_F = NULL,
  orientation = c("up", "down"),
  plot = TRUE,
  title = "Surface integral over z = g(x,y)"
)
}
\arguments{
\item{gfun}{Function of two variables \code{function(x, y)} returning
the height \code{z = g(x, y)} of the surface.}

\item{xlim}{Numeric vector of length 2 giving the range for x,
\code{c(x_min, x_max)} with \code{x_max > x_min}.}

\item{ylim}{Numeric vector of length 2 giving the range for y,
\code{c(y_min, y_max)} with \code{y_max > y_min}.}

\item{nx}{Integer, number of grid points in the x direction
(recommended: at least 20).}

\item{ny}{Integer, number of grid points in the y direction
(recommended: at least 20).}

\item{scalar_phi}{Optional scalar field \code{function(x, y, z)}.
If provided, the function computes the scalar surface integral
of \code{scalar_phi} over the surface.}

\item{vector_F}{Optional vector field \code{function(x, y, z)} that
returns a numeric vector of length 3 \code{c(Fx, Fy, Fz)}.
If provided, the function computes the flux integral of \code{vector_F}
across the oriented surface.}

\item{orientation}{Character string indicating the orientation of
the normal vector, either \code{"up"} or \code{"down"}. This affects
the sign of the flux integral.}

\item{plot}{Logical. If \code{TRUE}, returns a \pkg{plotly} surface
plot colored by the available integrand (scalar field times area
density or flux density).}

\item{title}{Character string used as the base title for the plot.}
}
\value{
A list with components:
\itemize{
\item \code{area_density_integral}: numeric scalar with the value
of the scalar surface integral (or \code{NA} if \code{scalar_phi}
is not supplied).
\item \code{flux_integral}: numeric scalar with the value of the
flux integral (or \code{NA} if \code{vector_F} is not supplied).
\item \code{plot}: a \pkg{plotly} surface object if \code{plot = TRUE},
otherwise \code{NULL}.
\item \code{grids}: list with matrices and grid information, including
\code{X}, \code{Y}, \code{Z}, partial derivatives, and weights.
\item \code{fields}: list with the scalar and/or flux integrand
evaluated on the grid.
}
}
\description{
Computes numeric approximations of surface integrals over a surface given
in graph form \code{z = g(x, y)} on a rectangular domain in the x-y plane.
}
\details{
Two types of integrals can be computed:
\enumerate{
\item A scalar surface integral of the form \code{Integral_S phi dS}, where
\code{phi(x, y, z)} is a scalar field evaluated on the surface.
\item A flux (vector surface integral) of the form
\code{Integral_S F dot n dS}, where \code{F(x, y, z)} is a vector field
and \code{n} is the chosen unit normal direction.
}

The surface is parametrized by \code{(x, y) -> (x, y, g(x, y))} over
a rectangular domain given by \code{xlim} and \code{ylim}. Partial
derivatives of \code{g} with respect to x and y are approximated by
finite differences on a uniform grid, and the integrals are computed
using a composite trapezoid rule on that grid.
}
\examples{
\dontshow{if (interactive()) \{}
# Surface z = x^2 + y^2 on [-1,1] x [-1,1]
gfun <- function(x, y) x^2 + y^2

# Scalar field phi(x,y,z) = 1 (surface area of the patch)
phi <- function(x, y, z) 1

# Vector field F = (0, 0, 1), flux through the surface
Fvec <- function(x, y, z) c(0, 0, 1)

res <- surface_integral_z(
  gfun,
  xlim = c(-1, 1),
  ylim = c(-1, 1),
  nx = 60, ny = 60,
  scalar_phi = phi,
  vector_F = Fvec,
  orientation = "up",
  plot = FALSE
)
res$area_density_integral
res$flux_integral
\dontshow{\}}

}
