% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osculating_ribbon3d.R
\name{osculating_ribbon3d}
\alias{osculating_ribbon3d}
\title{Osculating ribbon along a 3D parametric curve}
\usage{
osculating_ribbon3d(
  X,
  Y,
  Z,
  a,
  b,
  h = 1e-04,
  plot = FALSE,
  n_t = 400,
  n_u = 25,
  u_max = 1,
  colorscale = "Blues",
  opacity = 0.35,
  show_curve = TRUE,
  show_centers = TRUE,
  curve_line = list(color = "black", width = 2),
  centers_line = list(color = "red", width = 2),
  show_surface_grid = TRUE,
  surface_grid_color = "rgba(60,80,200,0.25)",
  surface_grid_width = 1,
  show_axis_grid = FALSE,
  scene = list(aspectmode = "data", xaxis = list(title = "x(t)"), yaxis = list(title =
    "y(t)"), zaxis = list(title = "z(t)")),
  bg = list(paper = "white", plot = "white"),
  lighting = list(ambient = 1, diffuse = 0.15, specular = 0, roughness = 1, fresnel = 0),
  tol = 1e-10
)
}
\arguments{
\item{X, Y, Z}{Functions returning the coordinate components of the curve as
functions of the parameter \code{t}.}

\item{a, b}{Numeric values giving the endpoints of the parameter interval.}

\item{h}{Step size used in the finite-difference approximations.}

\item{plot}{Logical; if \code{TRUE}, produces a 3D visualization of the
ribbon using \pkg{plotly}.}

\item{n_t}{Number of sample points along the curve.}

\item{n_u}{Number of subdivisions across the width of the ribbon.}

\item{u_max}{Half-width of the ribbon, measured in units of the normal
direction.}

\item{colorscale}{Character string giving the \pkg{plotly} colorscale used
for the ribbon surface.}

\item{opacity}{Numeric value between 0 and 1 controlling the transparency
of the ribbon.}

\item{show_curve}{Logical; if \code{TRUE}, draws the base curve.}

\item{show_centers}{Logical; if \code{TRUE}, draws the centerline joining
the midpoints of the ribbon cross-sections.}

\item{curve_line}{List with \pkg{plotly} style options for the base curve.}

\item{centers_line}{List with \pkg{plotly} style options for the
centerline.}

\item{show_surface_grid}{Logical; if \code{TRUE}, draws a grid on the
surface of the ribbon.}

\item{surface_grid_color}{Character string giving the color of the grid
lines on the ribbon.}

\item{surface_grid_width}{Numeric value giving the width of the surface
grid lines.}

\item{show_axis_grid}{Logical; if \code{TRUE}, displays gridlines on the
coordinate axes in the \pkg{plotly} scene.}

\item{scene}{List with 3D scene settings for the \pkg{plotly} figure.}

\item{bg}{List defining the background colors of the figure, typically
with entries \code{paper} and \code{plot}.}

\item{lighting}{List with lighting settings for the surface in
\pkg{plotly}.}

\item{tol}{Numeric tolerance used to detect numerical instabilities when
computing the derivative-based frame vectors.}
}
\value{
A list with two components:
\describe{
\item{\code{data}}{A tibble containing the sampled parameter
values, the coordinates of the curve, and the corresponding tangent,
normal and binormal directions.}
\item{\code{plot}}{A \pkg{plotly} object if \code{plot = TRUE}, otherwise
\code{NULL}.}
}
}
\description{
Constructs a narrow ribbon that follows a three-dimensional parametric
curve. The ribbon is based on the Frenet-Serret frame of the curve,
computed numerically along a set of sample points. The ribbon extends a
small distance in the normal direction of the curve, producing a thin
band that helps visualize how the curve bends and twists in space.
}
\details{
The function samples the curve at \code{n_t} points and computes the
numerical tangent, normal and binormal directions using finite-difference
approximations of the derivatives. At each sampled point, a short segment
is taken in the normal direction to define the width of the ribbon. These
segments are interpolated across the curve and subdivided according to
\code{n_u} to produce a mesh that represents the ribbon surface.

Optionally, the function can display the ribbon in an interactive 3D plot
using \pkg{plotly}. The base curve, the centerline, and optional grid
lines on the ribbon surface can be shown or hidden independently.
}
\examples{
X <- function(t) cos(t)
Y <- function(t) sin(t)
Z <- function(t) 0.2 * t
osculating_ribbon3d(X, Y, Z, a = 0, b = 4*pi, plot = FALSE)

}
